/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;
import org.apache.qpid.server.security.auth.sasl.anonymous.AnonymousInitialiser;
import org.apache.qpid.server.security.auth.sasl.anonymous.AnonymousSaslServer;

public class AnonymousAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(AnonymousAuthenticationManager.class);
    private static final AnonymousInitialiser SASL_INITIALISER = new AnonymousInitialiser();
    private static final String ANONYMOUS = SASL_INITIALISER.getMechanismName();
    private static final Principal ANONYMOUS_PRINCIPAL = new UsernamePrincipal("ANONYMOUS");
    public static final Subject ANONYMOUS_SUBJECT = new Subject();
    private static final AuthenticationResult ANONYMOUS_AUTHENTICATION;
    private static CallbackHandler _callbackHandler;
    static final AnonymousAuthenticationManager INSTANCE;
    public static final AuthenticationManagerPluginFactory<AnonymousAuthenticationManager> FACTORY;

    private AnonymousAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return ANONYMOUS;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (ANONYMOUS.equals(mechanism)) {
            return new AnonymousSaslServer();
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                return ANONYMOUS_AUTHENTICATION;
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return ANONYMOUS_AUTHENTICATION;
    }

    public void close() {
    }

    public void configure(ConfigurationPlugin config) throws ConfigurationException {
    }

    static {
        ANONYMOUS_SUBJECT.getPrincipals().add(ANONYMOUS_PRINCIPAL);
        ANONYMOUS_AUTHENTICATION = new AuthenticationResult(ANONYMOUS_SUBJECT);
        _callbackHandler = SASL_INITIALISER.getCallbackHandler();
        INSTANCE = new AnonymousAuthenticationManager();
        FACTORY = new AuthenticationManagerPluginFactory<AnonymousAuthenticationManager>(){

            @Override
            public AnonymousAuthenticationManager newInstance(ConfigurationPlugin config) throws ConfigurationException {
                AnonymousAuthenticationManagerConfiguration configuration;
                AnonymousAuthenticationManagerConfiguration anonymousAuthenticationManagerConfiguration = configuration = config == null ? null : (AnonymousAuthenticationManagerConfiguration)config.getConfiguration(AnonymousAuthenticationManagerConfiguration.class.getName());
                if (configuration == null) {
                    _logger.info((Object)"No authentication-manager configuration found for AnonymousAuthenticationManager");
                    return null;
                }
                return INSTANCE;
            }

            @Override
            public Class<AnonymousAuthenticationManager> getPluginClass() {
                return AnonymousAuthenticationManager.class;
            }

            @Override
            public String getPluginName() {
                return AnonymousAuthenticationManager.class.getName();
            }
        };
    }

    public static class AnonymousAuthenticationManagerConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.anonymous-auth-manager");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                AnonymousAuthenticationManagerConfiguration instance = new AnonymousAuthenticationManagerConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };

        public String[] getElementsProcessed() {
            return new String[0];
        }

        public void validateConfiguration() throws ConfigurationException {
        }
    }
}

