/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.subscription.MessageGroupManager;
import org.apache.qpid.server.subscription.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinedGroupMessageGroupManager
implements MessageGroupManager {
    private static final Logger _logger = LoggerFactory.getLogger(DefinedGroupMessageGroupManager.class);
    private final String _groupId;
    private final String _defaultGroup;
    private final Map<Object, Group> _groupMap = new HashMap<Object, Group>();
    private final MessageGroupManager.SubscriptionResetHelper _resetHelper;

    public DefinedGroupMessageGroupManager(String groupId, String defaultGroup, MessageGroupManager.SubscriptionResetHelper resetHelper) {
        this._groupId = groupId;
        this._defaultGroup = defaultGroup;
        this._resetHelper = resetHelper;
    }

    public synchronized Subscription getAssignedSubscription(QueueEntry entry) {
        Object groupId = this.getKey(entry);
        Group group = this._groupMap.get(groupId);
        return group == null || !group.isValid() ? null : group.getSubscription();
    }

    public synchronized boolean acceptMessage(Subscription sub, QueueEntry entry) {
        Subscription assignedSub;
        Object groupId = this.getKey(entry);
        Group group = this._groupMap.get(groupId);
        if (group == null || !group.isValid()) {
            group = new Group(groupId, sub);
            this._groupMap.put(groupId, group);
            if (this._resetHelper.isEntryAheadOfSubscription(entry, sub)) {
                return false;
            }
        }
        if ((assignedSub = group.getSubscription()) == sub) {
            entry.addStateChangeListener(new GroupStateChangeListener(group, entry));
            return true;
        }
        return false;
    }

    public synchronized QueueEntry findEarliestAssignedAvailableEntry(Subscription sub) {
        EntryFinder visitor = new EntryFinder(sub);
        sub.getQueue().visit(visitor);
        return visitor.getEntry();
    }

    public void clearAssignments(Subscription sub) {
    }

    private Object getKey(QueueEntry entry) {
        String groupVal;
        ServerMessage message = entry.getMessage();
        AMQMessageHeader messageHeader = message == null ? null : message.getMessageHeader();
        String string = groupVal = messageHeader == null ? this._defaultGroup : messageHeader.getHeader(this._groupId);
        if (groupVal == null) {
            groupVal = this._defaultGroup;
        }
        return groupVal;
    }

    private class GroupStateChangeListener
    implements QueueEntry.StateChangeListener {
        private final Group _group;

        public GroupStateChangeListener(Group group, QueueEntry entry) {
            this._group = group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(QueueEntry entry, QueueEntry.State oldState, QueueEntry.State newState) {
            DefinedGroupMessageGroupManager definedGroupMessageGroupManager = DefinedGroupMessageGroupManager.this;
            synchronized (definedGroupMessageGroupManager) {
                if (this._group.isValid()) {
                    if (oldState != newState) {
                        if (newState == QueueEntry.State.ACQUIRED) {
                            this._group.add();
                        } else if (oldState == QueueEntry.State.ACQUIRED) {
                            this._group.subtract();
                        }
                    }
                } else {
                    entry.removeStateChangeListener(this);
                }
            }
        }
    }

    private class EntryFinder
    implements QueueEntryVisitor {
        private QueueEntry _entry;
        private Subscription _sub;

        public EntryFinder(Subscription sub) {
            this._sub = sub;
        }

        public boolean visit(QueueEntry entry) {
            if (!entry.isAvailable()) {
                return false;
            }
            Object groupId = DefinedGroupMessageGroupManager.this.getKey(entry);
            Group group = (Group)DefinedGroupMessageGroupManager.this._groupMap.get(groupId);
            if (group != null && group.getSubscription() == this._sub) {
                this._entry = entry;
                return true;
            }
            return false;
        }

        public QueueEntry getEntry() {
            return this._entry;
        }
    }

    private final class Group {
        private final Object _group;
        private Subscription _subscription;
        private int _activeCount;

        private Group(Object key, Subscription subscription) {
            this._group = key;
            this._subscription = subscription;
        }

        public boolean add() {
            if (this._subscription != null) {
                ++this._activeCount;
                return true;
            }
            return false;
        }

        public void subtract() {
            if (--this._activeCount == 0) {
                DefinedGroupMessageGroupManager.this._resetHelper.resetSubPointersForGroups(this._subscription, false);
                this._subscription = null;
                DefinedGroupMessageGroupManager.this._groupMap.remove(this._group);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this._group.equals(group._group);
        }

        public int hashCode() {
            return this._group.hashCode();
        }

        public boolean isValid() {
            return this._subscription != null && (this._activeCount != 0 || !this._subscription.isClosed());
        }

        public Subscription getSubscription() {
            return this._subscription;
        }

        public String toString() {
            return "Group{_group=" + this._group + ", _subscription=" + this._subscription + ", _activeCount=" + this._activeCount + '}';
        }
    }
}

