/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.BrokerConfigurationStoreCreator;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.store.ManagementModeStoreHandler;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.log4j.LoggingManagementFacade;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Broker {
    private static final Logger LOGGER = Logger.getLogger(Broker.class);
    private volatile Thread _shutdownHookThread;
    private volatile IApplicationRegistry _applicationRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.removeShutdownHook();
        }
        finally {
            try {
                if (this._applicationRegistry != null) {
                    this._applicationRegistry.close();
                }
            }
            finally {
                this.clearAMQShortStringCache();
            }
        }
    }

    public void startup() throws Exception {
        this.startup(new BrokerOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(BrokerOptions options) throws Exception {
        CurrentActor.set(new BrokerActor(new SystemOutMessageLogger()));
        try {
            this.startupImpl(options);
            this.addShutdownHook();
        }
        finally {
            try {
                CurrentActor.remove();
            }
            finally {
                this.clearAMQShortStringCache();
            }
        }
    }

    private void startupImpl(BrokerOptions options) throws Exception {
        String storeLocation = options.getConfigurationStoreLocation();
        String storeType = options.getConfigurationStoreType();
        CurrentActor.get().message(BrokerMessages.CONFIG(storeLocation));
        if (!options.isSkipLoggingConfiguration()) {
            this.configureLogging(new File(options.getLogConfigFileLocation()), options.getLogWatchFrequency());
        }
        BrokerConfigurationStoreCreator storeCreator = new BrokerConfigurationStoreCreator();
        ConfigurationEntryStore store = storeCreator.createStore(storeLocation, storeType, options.getInitialConfigurationLocation(), options.isOverwriteConfigurationStore(), options.getConfigProperties());
        if (options.isManagementMode()) {
            store = new ManagementModeStoreHandler(store, options);
        }
        this._applicationRegistry = new ApplicationRegistry(store);
        try {
            this._applicationRegistry.initialise(options);
        }
        catch (Exception e) {
            try {
                this._applicationRegistry.close();
            }
            catch (Exception ce) {
                LOGGER.debug((Object)"An error occured when closing the registry following initialization failure", (Throwable)ce);
            }
            throw e;
        }
    }

    public static void parsePortList(Set<Integer> output, List<?> ports) throws InitException {
        if (ports != null) {
            for (Object o : ports) {
                try {
                    output.add(Integer.parseInt(String.valueOf(o)));
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + o, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogging(File logConfigFile, int logWatchTime) throws InitException, IOException {
        if (logConfigFile.exists() && logConfigFile.canRead()) {
            CurrentActor.get().message(BrokerMessages.LOG_CONFIG(logConfigFile.getAbsolutePath()));
            if (logWatchTime > 0) {
                System.out.println("log file " + logConfigFile.getAbsolutePath() + " will be checked for changes every " + logWatchTime + " seconds");
                try {
                    LoggingManagementFacade.configureAndWatch(logConfigFile.getPath(), logWatchTime * 1000);
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            } else {
                try {
                    LoggingManagementFacade.configure(logConfigFile.getPath());
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            }
        } else {
            System.err.println("Logging configuration error: unable to read file " + logConfigFile.getAbsolutePath());
            System.err.println("Using the fallback internal fallback-log4j.properties configuration");
            InputStream propsFile = this.getClass().getResourceAsStream("/fallback-log4j.properties");
            if (propsFile == null) {
                throw new IOException("Unable to load the fallback internal fallback-log4j.properties configuration file");
            }
            try {
                Properties fallbackProps = new Properties();
                fallbackProps.load(propsFile);
                PropertyConfigurator.configure((Properties)fallbackProps);
            }
            finally {
                propsFile.close();
            }
        }
    }

    private void addShutdownHook() {
        Thread shutdownHookThread = new Thread(new ShutdownService());
        shutdownHookThread.setName("QpidBrokerShutdownHook");
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        this._shutdownHookThread = shutdownHookThread;
        LOGGER.debug((Object)"Added shutdown hook");
    }

    private void removeShutdownHook() {
        Thread shutdownThread = this._shutdownHookThread;
        if (shutdownThread != null && Thread.currentThread() != shutdownThread) {
            LOGGER.debug((Object)"Removing shutdown hook");
            this._shutdownHookThread = null;
            boolean removed = false;
            try {
                removed = Runtime.getRuntime().removeShutdownHook(shutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removed shutdown hook: " + removed));
            }
        } else {
            LOGGER.debug((Object)"Skipping shutdown hook removal as there either isnt one, or we are it.");
        }
    }

    private void clearAMQShortStringCache() {
        AMQShortString.clearLocalCache();
    }

    public org.apache.qpid.server.model.Broker getBroker() {
        if (this._applicationRegistry == null) {
            return null;
        }
        return this._applicationRegistry.getBroker();
    }

    private class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        public void run() {
            LOGGER.debug((Object)"Shutdown hook running");
            Broker.this.shutdown();
        }
    }

    protected static class InitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

