/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import org.apache.qpid.AMQException;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.txn.ServerTransaction;

public class TransactionTimeoutHelper {
    private static final String OPEN_TRANSACTION_TIMEOUT_ERROR = "Open transaction timed out";
    private static final String IDLE_TRANSACTION_TIMEOUT_ERROR = "Idle transaction timed out";
    private final LogSubject _logSubject;
    private final CloseAction _closeAction;

    public TransactionTimeoutHelper(LogSubject logSubject, CloseAction closeAction) {
        this._logSubject = logSubject;
        this._closeAction = closeAction;
    }

    public void checkIdleOrOpenTimes(ServerTransaction transaction, long openWarn, long openClose, long idleWarn, long idleClose) throws AMQException {
        if (transaction.isTransactional()) {
            long idleTime;
            boolean closed;
            long transactionUpdateTime = transaction.getTransactionUpdateTime();
            if (transactionUpdateTime > 0L && (closed = this.logAndCloseIfNecessary(idleTime = System.currentTimeMillis() - transactionUpdateTime, idleWarn, idleClose, ChannelMessages.IDLE_TXN(idleTime), IDLE_TRANSACTION_TIMEOUT_ERROR))) {
                return;
            }
            long transactionStartTime = transaction.getTransactionStartTime();
            if (transactionStartTime > 0L) {
                long openTime = System.currentTimeMillis() - transactionStartTime;
                this.logAndCloseIfNecessary(openTime, openWarn, openClose, ChannelMessages.OPEN_TXN(openTime), OPEN_TRANSACTION_TIMEOUT_ERROR);
            }
        }
    }

    private boolean logAndCloseIfNecessary(long timeSoFar, long warnTimeout, long closeTimeout, LogMessage warnMessage, String closeMessage) throws AMQException {
        if (this.isTimedOut(timeSoFar, warnTimeout)) {
            LogActor logActor = CurrentActor.get();
            logActor.message(this._logSubject, warnMessage);
        }
        if (this.isTimedOut(timeSoFar, closeTimeout)) {
            this._closeAction.doTimeoutAction(closeMessage);
            return true;
        }
        return false;
    }

    private boolean isTimedOut(long timeSoFar, long timeout) {
        return timeout > 0L && timeSoFar > timeout;
    }

    public static interface CloseAction {
        public void doTimeoutAction(String var1) throws AMQException;
    }
}

