/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.XmlConfigurationUtilities;
import org.apache.qpid.server.configuration.plugins.AbstractConfiguration;
import org.apache.qpid.server.model.Broker;

public class VirtualHostConfiguration
extends AbstractConfiguration {
    private final String _name;
    private final Map<String, QueueConfiguration> _queues = new HashMap<String, QueueConfiguration>();
    private final Map<String, ExchangeConfiguration> _exchanges = new HashMap<String, ExchangeConfiguration>();
    private final Broker _broker;
    private final long _defaultHouseKeepingCheckPeriod;

    public VirtualHostConfiguration(String name, Configuration config, Broker broker) throws ConfigurationException {
        this._name = name;
        this._broker = broker;
        this._defaultHouseKeepingCheckPeriod = ((Number)this._broker.getAttribute("virtualhost.housekeepingCheckPeriod")).longValue();
        this.setConfiguration(config);
    }

    public VirtualHostConfiguration(String name, File configurationFile, Broker broker) throws ConfigurationException {
        this(name, VirtualHostConfiguration.loadConfiguration(name, configurationFile), broker);
    }

    private static Configuration loadConfiguration(String name, File configurationFile) throws ConfigurationException {
        Configuration configuration = null;
        if (configurationFile == null) {
            throw new IllegalConfigurationException("Virtualhost configuration file must be supplied!");
        }
        Configuration virtualHostConfig = XmlConfigurationUtilities.parseConfig(configurationFile);
        Configuration config = virtualHostConfig.subset("virtualhost." + XmlConfigurationUtilities.escapeTagName(name));
        if (config.isEmpty()) {
            throw new IllegalConfigurationException("No configuration found for virtual host '" + name + "' in " + configurationFile.getAbsolutePath());
        }
        configuration = config;
        return configuration;
    }

    public void setConfiguration(Configuration config) throws ConfigurationException {
        this.setConfiguration("virtualhosts.virtualhost", config);
        for (String queueName : this.getListValue("queues.queue.name")) {
            this._queues.put(queueName, new QueueConfiguration(queueName, this));
        }
        Iterator i = this.getListValue("exchanges.exchange.name").iterator();
        int count = 0;
        while (i.hasNext()) {
            CompositeConfiguration mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration(config.subset("exchanges.exchange(" + count++ + ")"));
            mungedConf.addConfiguration(this.getConfig().subset("exchanges"));
            String exchName = (String)i.next();
            this._exchanges.put(exchName, new ExchangeConfiguration(exchName, (Configuration)mungedConf));
        }
    }

    public String getName() {
        return this._name;
    }

    public long getHousekeepingCheckPeriod() {
        return this.getLongValue("housekeeping.checkPeriod", this._defaultHouseKeepingCheckPeriod);
    }

    public Configuration getStoreConfiguration() {
        return this.getConfig().subset("store");
    }

    public String getMessageStoreClass() {
        return this.getStringValue("store.class", null);
    }

    public void setMessageStoreClass(String storeFactoryClass) {
        this.getConfig().setProperty("store.class", (Object)storeFactoryClass);
    }

    public List getExchanges() {
        return this.getListValue("exchanges.exchange.name");
    }

    public String[] getQueueNames() {
        return this._queues.keySet().toArray(new String[this._queues.size()]);
    }

    public ExchangeConfiguration getExchangeConfiguration(String exchangeName) {
        return this._exchanges.get(exchangeName);
    }

    public QueueConfiguration getQueueConfiguration(String queueName) {
        if (this._queues.containsKey(queueName)) {
            return this._queues.get(queueName);
        }
        try {
            return new QueueConfiguration(queueName, this);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public int getMaximumMessageAge() {
        return this.getIntValue("queues.maximumMessageAge", this.getBrokerAttributeAsInt("queue.alertThresholdMessageAge"));
    }

    public Long getMaximumQueueDepth() {
        return this.getLongValue("queues.maximumQueueDepth", this.getBrokerAttributeAsLong("queue.alertThresholdQueueDepthBytes"));
    }

    public Long getMaximumMessageSize() {
        return this.getLongValue("queues.maximumMessageSize", this.getBrokerAttributeAsLong("queue.alertThresholdMessageSize"));
    }

    public Long getMaximumMessageCount() {
        return this.getLongValue("queues.maximumMessageCount", this.getBrokerAttributeAsLong("queue.alertThresholdQueueDepthMessages"));
    }

    public Long getMinimumAlertRepeatGap() {
        return this.getLongValue("queues.minimumAlertRepeatGap", this.getBrokerAttributeAsLong("queue.alertRepeatGap"));
    }

    public long getCapacity() {
        return this.getLongValue("queues.capacity", this.getBrokerAttributeAsLong("queue.flowControlSizeBytes"));
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("queues.flowResumeCapacity", this.getBrokerAttributeAsLong("queue.flowResumeSizeBytes"));
    }

    public String[] getElementsProcessed() {
        return new String[]{"queues", "exchanges", "custom-exchanges", "store", "housekeeping"};
    }

    public void validateConfiguration() throws ConfigurationException {
        if (this.getListValue("security.authentication.name").size() > 0) {
            String message = "Validation error : security/authentication/name is no longer a supported element within the configuration xml. It appears in virtual host definition : " + this._name;
            throw new ConfigurationException(message);
        }
        if (this.contains("housekeeping.expiredMessageCheckPeriod")) {
            String message = "Validation error : housekeeping/expiredMessageCheckPeriod must be replaced by housekeeping/checkPeriod. It appears in virtual host definition : " + this._name;
            throw new ConfigurationException(message);
        }
    }

    public int getHouseKeepingThreadCount() {
        return this.getIntValue("housekeeping.poolSize", Runtime.getRuntime().availableProcessors());
    }

    public long getTransactionTimeoutOpenWarn() {
        return this.getLongValue("transactionTimeout.openWarn", this.getBrokerAttributeAsLong("virtualhost.storeTransactionOpenTimeoutWarn"));
    }

    public long getTransactionTimeoutOpenClose() {
        return this.getLongValue("transactionTimeout.openClose", this.getBrokerAttributeAsLong("virtualhost.storeTransactionOpenTimeoutClose"));
    }

    public long getTransactionTimeoutIdleWarn() {
        return this.getLongValue("transactionTimeout.idleWarn", this.getBrokerAttributeAsLong("virtualhost.storeTransactionIdleTimeoutWarn"));
    }

    public long getTransactionTimeoutIdleClose() {
        return this.getLongValue("transactionTimeout.idleClose", this.getBrokerAttributeAsLong("virtualhost.storeTransactionIdleTimeoutClose"));
    }

    public int getMaxDeliveryCount() {
        return this.getIntValue("queues.maximumDeliveryCount", this.getBrokerAttributeAsInt("queue.maximumDeliveryAttempts"));
    }

    public boolean isDeadLetterQueueEnabled() {
        return this.getBooleanValue("queues.deadLetterQueues", this.getBrokerAttributeAsBoolean("queue.deadLetterQueueEnabled"));
    }

    private long getBrokerAttributeAsLong(String name) {
        Number brokerValue = (Number)this._broker.getAttribute(name);
        return brokerValue == null ? 0L : brokerValue.longValue();
    }

    private int getBrokerAttributeAsInt(String name) {
        Number brokerValue = (Number)this._broker.getAttribute(name);
        return brokerValue == null ? 0 : brokerValue.intValue();
    }

    private boolean getBrokerAttributeAsBoolean(String name) {
        Boolean brokerValue = (Boolean)this._broker.getAttribute(name);
        return brokerValue == null ? false : brokerValue;
    }

    public String getType() {
        return this.getStringValue("type", "org.apache.qpid.server.store.berkeleydb.BDBHAMessageStore".equals(this.getMessageStoreClass()) ? "BDB_HA" : "STANDARD");
    }
}

