/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import java.util.Map;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.RecovererProvider;
import org.apache.qpid.server.configuration.startup.RecovererHelper;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.adapter.AccessControlProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlProviderRecoverer
implements ConfiguredObjectRecoverer<AccessControlProvider> {
    private final AccessControlProviderFactory _accessControlProviderFactory;

    public AccessControlProviderRecoverer(AccessControlProviderFactory authenticationProviderFactory) {
        this._accessControlProviderFactory = authenticationProviderFactory;
    }

    @Override
    public AccessControlProvider create(RecovererProvider recovererProvider, ConfigurationEntry configurationEntry, ConfiguredObject ... parents) {
        Broker broker = RecovererHelper.verifyOnlyBrokerIsParent(parents);
        Map<String, Object> attributes = configurationEntry.getAttributes();
        AccessControlProvider authenticationProvider = this._accessControlProviderFactory.recover(configurationEntry.getId(), broker, attributes);
        return authenticationProvider;
    }
}

