/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.RecovererProvider;
import org.apache.qpid.server.configuration.startup.StoreUpgrader;
import org.apache.qpid.server.configuration.store.StoreConfigurationChangeListener;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.adapter.AccessControlProviderFactory;
import org.apache.qpid.server.model.adapter.AuthenticationProviderFactory;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.model.adapter.GroupProviderFactory;
import org.apache.qpid.server.model.adapter.PortFactory;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerRecoverer
implements ConfiguredObjectRecoverer<Broker> {
    private static final Pattern MODEL_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+$");
    private final StatisticsGatherer _statisticsGatherer;
    private final VirtualHostRegistry _virtualHostRegistry;
    private final LogRecorder _logRecorder;
    private final RootMessageLogger _rootMessageLogger;
    private final AuthenticationProviderFactory _authenticationProviderFactory;
    private final AccessControlProviderFactory _accessControlProviderFactory;
    private final PortFactory _portFactory;
    private final TaskExecutor _taskExecutor;
    private final BrokerOptions _brokerOptions;
    private final GroupProviderFactory _groupProviderFactory;

    public BrokerRecoverer(AuthenticationProviderFactory authenticationProviderFactory, GroupProviderFactory groupProviderFactory, AccessControlProviderFactory accessControlProviderFactory, PortFactory portFactory, StatisticsGatherer statisticsGatherer, VirtualHostRegistry virtualHostRegistry, LogRecorder logRecorder, RootMessageLogger rootMessageLogger, TaskExecutor taskExecutor, BrokerOptions brokerOptions) {
        this._groupProviderFactory = groupProviderFactory;
        this._portFactory = portFactory;
        this._authenticationProviderFactory = authenticationProviderFactory;
        this._accessControlProviderFactory = accessControlProviderFactory;
        this._statisticsGatherer = statisticsGatherer;
        this._virtualHostRegistry = virtualHostRegistry;
        this._logRecorder = logRecorder;
        this._rootMessageLogger = rootMessageLogger;
        this._taskExecutor = taskExecutor;
        this._brokerOptions = brokerOptions;
    }

    @Override
    public Broker create(RecovererProvider recovererProvider, ConfigurationEntry entry, ConfiguredObject ... parents) {
        Map<String, Object> attributesCopy = this.validateAttributes(entry);
        attributesCopy.put("modelVersion", "1.1");
        StoreConfigurationChangeListener storeChangeListener = new StoreConfigurationChangeListener(entry.getStore());
        BrokerAdapter broker = new BrokerAdapter(entry.getId(), attributesCopy, this._statisticsGatherer, this._virtualHostRegistry, this._logRecorder, this._rootMessageLogger, this._authenticationProviderFactory, this._groupProviderFactory, this._accessControlProviderFactory, this._portFactory, this._taskExecutor, entry.getStore(), this._brokerOptions);
        broker.addChangeListener(storeChangeListener);
        HashMap<String, Collection<ConfigurationEntry>> childEntries = new HashMap<String, Collection<ConfigurationEntry>>(entry.getChildren());
        HashMap<String, Collection<ConfigurationEntry>> priorityChildEntries = new HashMap<String, Collection<ConfigurationEntry>>(childEntries);
        ArrayList types = new ArrayList(childEntries.keySet());
        for (String type : types) {
            if (KeyStore.class.getSimpleName().equals(type) || TrustStore.class.getSimpleName().equals(type) || AuthenticationProvider.class.getSimpleName().equals(type)) {
                childEntries.remove(type);
                continue;
            }
            priorityChildEntries.remove(type);
        }
        for (String type : priorityChildEntries.keySet()) {
            this.recoverType(recovererProvider, storeChangeListener, broker, priorityChildEntries, type);
        }
        for (String type : childEntries.keySet()) {
            this.recoverType(recovererProvider, storeChangeListener, broker, childEntries, type);
        }
        return broker;
    }

    private Map<String, Object> validateAttributes(ConfigurationEntry entry) {
        Map<String, Object> attributes = entry.getAttributes();
        String modelVersion = null;
        if (attributes.containsKey("modelVersion")) {
            modelVersion = MapValueConverter.getStringAttribute("modelVersion", attributes, null);
        }
        if (modelVersion == null) {
            throw new IllegalConfigurationException("Broker modelVersion must be specified");
        }
        if (!MODEL_VERSION_PATTERN.matcher(modelVersion).matches()) {
            throw new IllegalConfigurationException("Broker modelVersion is specified in incorrect format: " + modelVersion);
        }
        int versionSeparatorPosition = modelVersion.indexOf(".");
        String majorVersionPart = modelVersion.substring(0, versionSeparatorPosition);
        int majorModelVersion = Integer.parseInt(majorVersionPart);
        int minorModelVersion = Integer.parseInt(modelVersion.substring(versionSeparatorPosition + 1));
        if (majorModelVersion != 1 || minorModelVersion > 1) {
            throw new IllegalConfigurationException("The model version '" + modelVersion + "' in configuration is incompatible with the broker model version '" + "1.1" + "'");
        }
        if (!"1.1".equals(modelVersion)) {
            String oldVersion;
            do {
                oldVersion = modelVersion;
                StoreUpgrader.upgrade(entry.getStore());
            } while (!(modelVersion = MapValueConverter.getStringAttribute("modelVersion", attributes = (entry = entry.getStore().getRootEntry()).getAttributes(), null)).equals(oldVersion) && !modelVersion.equals("1.1"));
        }
        return new HashMap<String, Object>(attributes);
    }

    private void recoverType(RecovererProvider recovererProvider, StoreConfigurationChangeListener storeChangeListener, BrokerAdapter broker, Map<String, Collection<ConfigurationEntry>> childEntries, String type) {
        ConfiguredObjectRecoverer<? extends ConfiguredObject> recoverer = recovererProvider.getRecoverer(type);
        if (recoverer == null) {
            throw new IllegalConfigurationException("Cannot recover entry for the type '" + type + "' from broker");
        }
        Collection<ConfigurationEntry> entries = childEntries.get(type);
        for (ConfigurationEntry childEntry : entries) {
            ConfiguredObject object = recoverer.create(recovererProvider, childEntry, broker);
            if (object == null) {
                throw new IllegalConfigurationException("Cannot create configured object for the entry " + childEntry);
            }
            broker.recoverChild(object);
            object.addChangeListener(storeChangeListener);
        }
    }
}

