/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.RecovererProvider;
import org.apache.qpid.server.configuration.startup.AccessControlProviderRecoverer;
import org.apache.qpid.server.configuration.startup.AuthenticationProviderRecoverer;
import org.apache.qpid.server.configuration.startup.BrokerRecoverer;
import org.apache.qpid.server.configuration.startup.GroupProviderRecoverer;
import org.apache.qpid.server.configuration.startup.KeyStoreRecoverer;
import org.apache.qpid.server.configuration.startup.PluginRecoverer;
import org.apache.qpid.server.configuration.startup.PortRecoverer;
import org.apache.qpid.server.configuration.startup.TrustStoreRecoverer;
import org.apache.qpid.server.configuration.startup.VirtualHostRecoverer;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AccessControlProviderFactory;
import org.apache.qpid.server.model.adapter.AuthenticationProviderFactory;
import org.apache.qpid.server.model.adapter.GroupProviderFactory;
import org.apache.qpid.server.model.adapter.PortFactory;
import org.apache.qpid.server.plugin.AccessControlFactory;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.plugin.GroupManagerFactory;
import org.apache.qpid.server.plugin.PluginFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRecovererProvider
implements RecovererProvider {
    private final StatisticsGatherer _brokerStatisticsGatherer;
    private final VirtualHostRegistry _virtualHostRegistry;
    private final LogRecorder _logRecorder;
    private final RootMessageLogger _rootMessageLogger;
    private final AuthenticationProviderFactory _authenticationProviderFactory = new AuthenticationProviderFactory(new QpidServiceLoader<AuthenticationManagerFactory>());
    private final AccessControlProviderFactory _accessControlProviderFactory = new AccessControlProviderFactory(new QpidServiceLoader<AccessControlFactory>());
    private final PortFactory _portFactory;
    private final GroupProviderFactory _groupProviderFactory = new GroupProviderFactory(new QpidServiceLoader<GroupManagerFactory>());
    private final QpidServiceLoader<PluginFactory> _pluginFactoryServiceLoader;
    private final TaskExecutor _taskExecutor;
    private final BrokerOptions _brokerOptions;

    public DefaultRecovererProvider(StatisticsGatherer brokerStatisticsGatherer, VirtualHostRegistry virtualHostRegistry, LogRecorder logRecorder, RootMessageLogger rootMessageLogger, TaskExecutor taskExecutor, BrokerOptions brokerOptions) {
        this._portFactory = new PortFactory();
        this._brokerStatisticsGatherer = brokerStatisticsGatherer;
        this._virtualHostRegistry = virtualHostRegistry;
        this._logRecorder = logRecorder;
        this._rootMessageLogger = rootMessageLogger;
        this._pluginFactoryServiceLoader = new QpidServiceLoader();
        this._taskExecutor = taskExecutor;
        this._brokerOptions = brokerOptions;
    }

    public ConfiguredObjectRecoverer<?> getRecoverer(String type) {
        if (Broker.class.getSimpleName().equals(type)) {
            return new BrokerRecoverer(this._authenticationProviderFactory, this._groupProviderFactory, this._accessControlProviderFactory, this._portFactory, this._brokerStatisticsGatherer, this._virtualHostRegistry, this._logRecorder, this._rootMessageLogger, this._taskExecutor, this._brokerOptions);
        }
        if (VirtualHost.class.getSimpleName().equals(type)) {
            return new VirtualHostRecoverer(this._brokerStatisticsGatherer);
        }
        if (AccessControlProvider.class.getSimpleName().equals(type)) {
            return new AccessControlProviderRecoverer(this._accessControlProviderFactory);
        }
        if (AuthenticationProvider.class.getSimpleName().equals(type)) {
            return new AuthenticationProviderRecoverer(this._authenticationProviderFactory);
        }
        if (Port.class.getSimpleName().equals(type)) {
            return new PortRecoverer(this._portFactory);
        }
        if (GroupProvider.class.getSimpleName().equals(type)) {
            return new GroupProviderRecoverer(this._groupProviderFactory);
        }
        if (KeyStore.class.getSimpleName().equals(type)) {
            return new KeyStoreRecoverer();
        }
        if (TrustStore.class.getSimpleName().equals(type)) {
            return new TrustStoreRecoverer();
        }
        if (Plugin.class.getSimpleName().equals(type)) {
            return new PluginRecoverer(this._pluginFactoryServiceLoader);
        }
        return null;
    }
}

