/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.RecovererProvider;
import org.apache.qpid.server.configuration.startup.RecovererHelper;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.plugin.PluginFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRecoverer
implements ConfiguredObjectRecoverer<ConfiguredObject> {
    private QpidServiceLoader<PluginFactory> _serviceLoader;

    public PluginRecoverer(QpidServiceLoader<PluginFactory> serviceLoader) {
        this._serviceLoader = serviceLoader;
    }

    @Override
    public ConfiguredObject create(RecovererProvider recovererProvider, ConfigurationEntry configurationEntry, ConfiguredObject ... parents) {
        Broker broker = RecovererHelper.verifyOnlyBrokerIsParent(parents);
        Map<String, Object> attributes = configurationEntry.getAttributes();
        Iterable<PluginFactory> factories = this._serviceLoader.instancesOf(PluginFactory.class);
        for (PluginFactory pluginFactory : factories) {
            UUID configurationId;
            Plugin pluginObject = pluginFactory.createInstance(configurationId = configurationEntry.getId(), attributes, broker);
            if (pluginObject == null) continue;
            UUID pluginId = pluginObject.getId();
            if (!configurationId.equals(pluginId)) {
                throw new IllegalStateException("Plugin object id '" + pluginId + "' does not equal expected id " + configurationId);
            }
            return pluginObject;
        }
        throw new IllegalConfigurationException("Cannot create a plugin object for " + attributes + " with factories " + factories);
    }
}

