/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;

public abstract class StoreUpgrader {
    private static Map<String, StoreUpgrader> _upgraders = new HashMap<String, StoreUpgrader>();
    private static final StoreUpgrader UPGRADE_1_0 = new StoreUpgrader("1.0"){

        protected void doUpgrade(ConfigurationEntryStore store) {
            ConfigurationEntry root = store.getRootEntry();
            Map<String, Collection<ConfigurationEntry>> children = root.getChildren();
            Collection<ConfigurationEntry> vhosts = children.get("VirtualHost");
            HashSet<ConfigurationEntry> changed = new HashSet<ConfigurationEntry>();
            for (ConfigurationEntry vhost : vhosts) {
                Map<String, Object> attributes = vhost.getAttributes();
                if (!attributes.containsKey("storeType")) continue;
                attributes = new HashMap<String, Object>(attributes);
                attributes.put("type", "STANDARD");
                changed.add(new ConfigurationEntry(vhost.getId(), vhost.getType(), attributes, vhost.getChildrenIds(), store));
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(root.getAttributes());
            attributes.put("modelVersion", "1.1");
            changed.add(new ConfigurationEntry(root.getId(), root.getType(), attributes, root.getChildrenIds(), store));
            store.save(changed.toArray(new ConfigurationEntry[changed.size()]));
        }
    };

    private StoreUpgrader(String version) {
        _upgraders.put(version, this);
    }

    public static void upgrade(ConfigurationEntryStore store) {
        StoreUpgrader upgrader = _upgraders.get(store.getRootEntry().getAttributes().get("modelVersion").toString());
        if (upgrader != null) {
            upgrader.doUpgrade(store);
        }
    }

    protected abstract void doUpgrade(ConfigurationEntryStore var1);
}

