/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.MemoryConfigurationEntryStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConfigurationEntryStore
extends MemoryConfigurationEntryStore {
    public static final String STORE_TYPE = "json";
    private File _storeFile;

    public JsonConfigurationEntryStore(String storeLocation, ConfigurationEntryStore initialStore, boolean overwrite, Map<String, String> configProperties) {
        super(configProperties);
        this._storeFile = new File(storeLocation);
        if (this._storeFile.isDirectory()) {
            throw new IllegalConfigurationException("A directory exists at the location for the broker configuration store file: " + storeLocation);
        }
        if (overwrite && this._storeFile.exists() && !this._storeFile.delete()) {
            throw new RuntimeException("Unable to overwrite existing configuration store file as requested: " + storeLocation);
        }
        if (!this._storeFile.exists() || this._storeFile.length() == 0L) {
            this.initialiseStore(this._storeFile, initialStore);
        }
        this.load(this.getConfigurationEntryStoreUtil().fileToURL(this._storeFile));
        if (this.isGeneratedObjectIdDuringLoad()) {
            this.saveAsTree(this._storeFile);
        }
    }

    @Override
    public synchronized UUID[] remove(UUID ... entryIds) {
        UUID[] removedIds = super.remove(entryIds);
        if (removedIds.length > 0) {
            this.saveAsTree(this._storeFile);
        }
        return removedIds;
    }

    @Override
    public synchronized void save(ConfigurationEntry ... entries) {
        if (this.replaceEntries(entries)) {
            this.saveAsTree(this._storeFile);
        }
    }

    @Override
    public String getStoreLocation() {
        return this._storeFile.getAbsolutePath();
    }

    @Override
    public String getType() {
        return STORE_TYPE;
    }

    @Override
    public String toString() {
        return "JsonConfigurationEntryStore [_storeFile=" + this._storeFile + ", _rootId=" + this.getRootEntry().getId() + "]";
    }

    private void initialiseStore(File storeFile, ConfigurationEntryStore initialStore) {
        this.createFileIfNotExist(storeFile);
        if (initialStore == null) {
            throw new IllegalConfigurationException("Cannot create new store without an initial store");
        }
        if (initialStore instanceof MemoryConfigurationEntryStore && initialStore.getStoreLocation() != null) {
            this.getConfigurationEntryStoreUtil().copyInitialConfigFile(initialStore.getStoreLocation(), storeFile);
        } else {
            ConfigurationEntry rootEntry = initialStore.getRootEntry();
            HashMap<UUID, ConfigurationEntry> entries = new HashMap<UUID, ConfigurationEntry>();
            this.copyEntry(rootEntry.getId(), initialStore, entries);
            this.saveAsTree(rootEntry.getId(), entries, this.getObjectMapper(), storeFile, this.getVersion());
        }
    }
}

