/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementModeStoreHandler
implements ConfigurationEntryStore {
    private static final Logger LOGGER = Logger.getLogger(ManagementModeStoreHandler.class);
    private static final String MANAGEMENT_MODE_PORT_PREFIX = "MANAGEMENT-MODE-PORT-";
    private static final String PORT_TYPE = Port.class.getSimpleName();
    private static final String VIRTUAL_HOST_TYPE = VirtualHost.class.getSimpleName();
    private static final String ATTRIBUTE_STATE = "state";
    private static final Object MANAGEMENT_MODE_AUTH_PROVIDER = "mm-auth";
    private final ConfigurationEntryStore _store;
    private final Map<UUID, ConfigurationEntry> _cliEntries;
    private final Map<UUID, Object> _quiescedEntries;
    private final UUID _rootId;

    public ManagementModeStoreHandler(ConfigurationEntryStore store, BrokerOptions options) {
        ConfigurationEntry storeRoot = store.getRootEntry();
        this._store = store;
        this._rootId = storeRoot.getId();
        this._cliEntries = this.createPortsFromCommadLineOptions(options);
        this._quiescedEntries = this.quiesceEntries(storeRoot, options);
    }

    @Override
    public ConfigurationEntry getRootEntry() {
        return this.getEntry(this._rootId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationEntry getEntry(UUID id) {
        ConfigurationEntryStore configurationEntryStore = this._store;
        synchronized (configurationEntryStore) {
            if (this._cliEntries.containsKey(id)) {
                return this._cliEntries.get(id);
            }
            ConfigurationEntry entry = this._store.getEntry(id);
            if (this._quiescedEntries.containsKey(id)) {
                entry = this.createEntryWithState(entry, (Object)State.QUIESCED);
            } else if (id == this._rootId) {
                entry = this.createRootWithCLIEntries(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationEntry ... entries) {
        ConfigurationEntryStore configurationEntryStore = this._store;
        synchronized (configurationEntryStore) {
            ConfigurationEntry[] entriesToSave = new ConfigurationEntry[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                ConfigurationEntry entry = entries[i];
                UUID id = entry.getId();
                if (this._cliEntries.containsKey(id)) {
                    throw new IllegalConfigurationException("Cannot save configuration provided as command line argument:" + entry);
                }
                if (this._quiescedEntries.containsKey(id)) {
                    entry = this.createEntryWithState(entry, this._quiescedEntries.get(ATTRIBUTE_STATE));
                } else if (this._rootId.equals(id)) {
                    HashSet<UUID> childrenIds = new HashSet<UUID>(entry.getChildrenIds());
                    if (!this._cliEntries.isEmpty()) {
                        childrenIds.removeAll(this._cliEntries.entrySet());
                    }
                    HashMap<String, Object> attributes = new HashMap<String, Object>(entry.getAttributes());
                    entry = new ConfigurationEntry(entry.getId(), entry.getType(), attributes, childrenIds, this);
                }
                entriesToSave[i] = entry;
            }
            this._store.save(entriesToSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID[] remove(UUID ... entryIds) {
        ConfigurationEntryStore configurationEntryStore = this._store;
        synchronized (configurationEntryStore) {
            for (UUID id : entryIds) {
                if (!this._cliEntries.containsKey(id)) continue;
                throw new IllegalConfigurationException("Cannot change configuration for command line entry:" + this._cliEntries.get(id));
            }
            UUID[] result = this._store.remove(entryIds);
            for (UUID id : entryIds) {
                if (!this._quiescedEntries.containsKey(id)) continue;
                this._quiescedEntries.remove(id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(String copyLocation) {
        ConfigurationEntryStore configurationEntryStore = this._store;
        synchronized (configurationEntryStore) {
            this._store.copyTo(copyLocation);
        }
    }

    @Override
    public String getStoreLocation() {
        return this._store.getStoreLocation();
    }

    @Override
    public int getVersion() {
        return this._store.getVersion();
    }

    @Override
    public String getType() {
        return this._store.getType();
    }

    private Map<UUID, ConfigurationEntry> createPortsFromCommadLineOptions(BrokerOptions options) {
        ConfigurationEntry entry;
        int managementModeRmiPortOverride = options.getManagementModeRmiPortOverride();
        if (managementModeRmiPortOverride < 0) {
            throw new IllegalConfigurationException("Invalid rmi port is specified: " + managementModeRmiPortOverride);
        }
        int managementModeJmxPortOverride = options.getManagementModeJmxPortOverride();
        if (managementModeJmxPortOverride < 0) {
            throw new IllegalConfigurationException("Invalid jmx port is specified: " + managementModeJmxPortOverride);
        }
        int managementModeHttpPortOverride = options.getManagementModeHttpPortOverride();
        if (managementModeHttpPortOverride < 0) {
            throw new IllegalConfigurationException("Invalid http port is specified: " + managementModeHttpPortOverride);
        }
        HashMap<UUID, ConfigurationEntry> cliEntries = new HashMap<UUID, ConfigurationEntry>();
        if (managementModeRmiPortOverride != 0) {
            entry = this.createCLIPortEntry(managementModeRmiPortOverride, Protocol.RMI);
            cliEntries.put(entry.getId(), entry);
            if (managementModeJmxPortOverride == 0) {
                ConfigurationEntry connectorEntry = this.createCLIPortEntry(managementModeRmiPortOverride + 100, Protocol.JMX_RMI);
                cliEntries.put(connectorEntry.getId(), connectorEntry);
            }
        }
        if (managementModeJmxPortOverride != 0) {
            entry = this.createCLIPortEntry(managementModeJmxPortOverride, Protocol.JMX_RMI);
            cliEntries.put(entry.getId(), entry);
        }
        if (managementModeHttpPortOverride != 0) {
            entry = this.createCLIPortEntry(managementModeHttpPortOverride, Protocol.HTTP);
            cliEntries.put(entry.getId(), entry);
        }
        return cliEntries;
    }

    private ConfigurationEntry createCLIPortEntry(int port, Protocol protocol) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("port", port);
        attributes.put("protocols", Collections.singleton(protocol));
        attributes.put("name", MANAGEMENT_MODE_PORT_PREFIX + protocol.name());
        if (protocol != Protocol.RMI) {
            attributes.put("authenticationProvider", MANAGEMENT_MODE_AUTH_PROVIDER);
        }
        ConfigurationEntry portEntry = new ConfigurationEntry(UUID.randomUUID(), PORT_TYPE, attributes, Collections.<UUID>emptySet(), this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Add management mode port configuration " + portEntry + " for port " + port + " and protocol " + (Object)((Object)protocol)));
        }
        return portEntry;
    }

    private ConfigurationEntry createRootWithCLIEntries(ConfigurationEntry storeRoot) {
        HashSet<UUID> childrenIds = new HashSet<UUID>(storeRoot.getChildrenIds());
        if (!this._cliEntries.isEmpty()) {
            childrenIds.addAll(this._cliEntries.keySet());
        }
        ConfigurationEntry root = new ConfigurationEntry(storeRoot.getId(), storeRoot.getType(), new HashMap<String, Object>(storeRoot.getAttributes()), childrenIds, this);
        return root;
    }

    private Map<UUID, Object> quiesceEntries(ConfigurationEntry storeRoot, BrokerOptions options) {
        HashMap<UUID, Object> quiescedEntries = new HashMap<UUID, Object>();
        int managementModeRmiPortOverride = options.getManagementModeRmiPortOverride();
        int managementModeJmxPortOverride = options.getManagementModeJmxPortOverride();
        int managementModeHttpPortOverride = options.getManagementModeHttpPortOverride();
        Set<UUID> childrenIds = storeRoot.getChildrenIds();
        for (UUID id : childrenIds) {
            ConfigurationEntry entry = this._store.getEntry(id);
            String entryType = entry.getType();
            Map<String, Object> attributes = entry.getAttributes();
            boolean quiesce = false;
            if (VIRTUAL_HOST_TYPE.equals(entryType) && options.isManagementModeQuiesceVirtualHosts()) {
                quiesce = true;
            } else if (PORT_TYPE.equals(entryType)) {
                if (attributes == null) {
                    throw new IllegalConfigurationException("Port attributes are not set in " + entry);
                }
                Set<Protocol> protocols = this.getPortProtocolsAttribute(attributes);
                if (protocols == null) {
                    quiesce = true;
                } else {
                    block6: for (Protocol protocol : protocols) {
                        switch (protocol) {
                            case JMX_RMI: {
                                quiesce = managementModeJmxPortOverride > 0 || managementModeRmiPortOverride > 0;
                                continue block6;
                            }
                            case RMI: {
                                quiesce = managementModeRmiPortOverride > 0;
                                continue block6;
                            }
                            case HTTP: {
                                quiesce = managementModeHttpPortOverride > 0;
                                continue block6;
                            }
                        }
                        quiesce = true;
                    }
                }
            }
            if (!quiesce) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Management mode quiescing entry " + entry));
            }
            quiescedEntries.put(entry.getId(), attributes.get(ATTRIBUTE_STATE));
        }
        return quiescedEntries;
    }

    private Set<Protocol> getPortProtocolsAttribute(Map<String, Object> attributes) {
        Object object = attributes.get("protocols");
        if (object == null) {
            return null;
        }
        return MapValueConverter.getEnumSetAttribute("protocols", attributes, Protocol.class);
    }

    private ConfigurationEntry createEntryWithState(ConfigurationEntry entry, Object state) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(entry.getAttributes());
        if (state == null) {
            attributes.remove(ATTRIBUTE_STATE);
        } else {
            attributes.put(ATTRIBUTE_STATE, state);
        }
        Set<UUID> originalChildren = entry.getChildrenIds();
        HashSet<UUID> children = null;
        if (originalChildren != null) {
            children = new HashSet<UUID>(originalChildren);
        }
        return new ConfigurationEntry(entry.getId(), entry.getType(), attributes, children, entry.getStore());
    }
}

