/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.updater;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.security.SecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutor {
    private static final String TASK_EXECUTION_THREAD_NAME = "Broker-Configuration-Thread";
    private static final Logger LOGGER = Logger.getLogger(TaskExecutor.class);
    private volatile Thread _taskThread;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.INITIALISING);
    private volatile ExecutorService _executor;

    public State getState() {
        return this._state.get();
    }

    public void start() {
        if (this._state.compareAndSet(State.INITIALISING, State.ACTIVE)) {
            LOGGER.debug((Object)"Starting task executor");
            this._executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    TaskExecutor.this._taskThread = new Thread(r, TaskExecutor.TASK_EXECUTION_THREAD_NAME);
                    return TaskExecutor.this._taskThread;
                }
            });
            LOGGER.debug((Object)"Task executor is started");
        }
    }

    public void stopImmediately() {
        ExecutorService executor;
        if (this._state.compareAndSet(State.ACTIVE, State.STOPPED) && (executor = this._executor) != null) {
            LOGGER.debug((Object)"Stopping task executor immediately");
            List<Runnable> cancelledTasks = executor.shutdownNow();
            if (cancelledTasks != null) {
                for (Runnable runnable : cancelledTasks) {
                    if (!(runnable instanceof RunnableFuture)) continue;
                    ((RunnableFuture)runnable).cancel(true);
                }
            }
            this._executor = null;
            this._taskThread = null;
            LOGGER.debug((Object)("Task executor was stopped immediately. Number of unfinished tasks: " + cancelledTasks.size()));
        }
    }

    public void stop() {
        ExecutorService executor;
        if (this._state.compareAndSet(State.ACTIVE, State.STOPPED) && (executor = this._executor) != null) {
            LOGGER.debug((Object)"Stopping task executor");
            executor.shutdown();
            this._executor = null;
            this._taskThread = null;
            LOGGER.debug((Object)"Task executor is stopped");
        }
    }

    Future<?> submit(Callable<?> task) {
        this.checkState();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Submitting task: " + task));
        }
        Future<Object> future = null;
        if (this.isTaskExecutorThread()) {
            Object result = this.executeTaskAndHandleExceptions(task);
            return new ImmediateFuture(result);
        }
        future = this._executor.submit(new CallableWrapper(task));
        return future;
    }

    public Object submitAndWait(Callable<?> task) throws CancellationException {
        try {
            Future<?> future = this.submit(task);
            return future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Task execution was interrupted: " + task, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Exception) {
                throw new RuntimeException("Failed to execute user task: " + task, cause);
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Failed to execute user task: " + task, cause);
        }
    }

    public boolean isTaskExecutorThread() {
        return Thread.currentThread() == this._taskThread;
    }

    private void checkState() {
        if (this._state.get() != State.ACTIVE) {
            throw new IllegalStateException("Task executor is not in ACTIVE state");
        }
    }

    private Object executeTaskAndHandleExceptions(Callable<?> userTask) {
        try {
            return this.executeTask(userTask);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to execute user task: " + userTask, e);
        }
    }

    private Object executeTask(Callable<?> userTask) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Performing task " + userTask));
        }
        Object result = userTask.call();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Task " + userTask + " is performed successfully with result:" + result));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmediateFuture
    implements Future<Object> {
        private Object _result;

        public ImmediateFuture(Object result) {
            this._result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Object get() {
            return this._result;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallableWrapper
    implements Callable<Object> {
        private Callable<?> _userTask;
        private Subject _securityManagerSubject;
        private LogActor _actor;
        private Subject _contextSubject;

        public CallableWrapper(Callable<?> userWork) {
            this._userTask = userWork;
            this._securityManagerSubject = SecurityManager.getThreadSubject();
            this._actor = CurrentActor.get();
            this._contextSubject = Subject.getSubject(AccessController.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            SecurityManager.setThreadSubject(this._securityManagerSubject);
            CurrentActor.set(this._actor);
            try {
                Object result = null;
                try {
                    result = Subject.doAs(this._contextSubject, new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return TaskExecutor.this.executeTask(CallableWrapper.this._userTask);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                Object object = result;
                return object;
            }
            finally {
                try {
                    CurrentActor.remove();
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Unxpected exception on current actor removal", (Throwable)e);
                }
                try {
                    SecurityManager.setThreadSubject(null);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Unxpected exception on nullifying of subject for a security manager", (Throwable)e);
                }
            }
        }
    }
}

