/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BindingMessages;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.logging.subjects.BindingLogSubject;
import org.apache.qpid.server.logging.subjects.ExchangeLogSubject;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.store.DurableConfigurationStoreHelper;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExchange
implements Exchange {
    private static final Logger _logger = Logger.getLogger(AbstractExchange.class);
    private AMQShortString _name;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private Exchange _alternateExchange;
    private boolean _durable;
    private VirtualHost _virtualHost;
    private final List<Task> _closeTaskList = new CopyOnWriteArrayList<Task>();
    private boolean _autoDelete;
    private LogSubject _logSubject;
    private Map<ExchangeReferrer, Object> _referrers = new ConcurrentHashMap<ExchangeReferrer, Object>();
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private final ExchangeType<? extends Exchange> _type;
    private UUID _id;
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    private final AtomicLong _receivedMessageCount = new AtomicLong();
    private final AtomicLong _receivedMessageSize = new AtomicLong();
    private final AtomicLong _routedMessageCount = new AtomicLong();
    private final AtomicLong _routedMessageSize = new AtomicLong();
    private final AtomicLong _droppedMessageCount = new AtomicLong();
    private final AtomicLong _droppedMessageSize = new AtomicLong();
    private final CopyOnWriteArrayList<Exchange.BindingListener> _listeners = new CopyOnWriteArrayList();
    private long _createTime = System.currentTimeMillis();
    private final ConcurrentHashMap<BindingImpl, BindingImpl> _bindingsMap = new ConcurrentHashMap();

    public AbstractExchange(ExchangeType<? extends Exchange> type) {
        this._type = type;
    }

    @Override
    public AMQShortString getNameShortString() {
        return this._name;
    }

    @Override
    public final AMQShortString getTypeShortString() {
        return this._type.getName();
    }

    @Override
    public void initialise(UUID id, VirtualHost host, AMQShortString name, boolean durable, boolean autoDelete) throws AMQException {
        this._virtualHost = host;
        this._name = name;
        this._durable = durable;
        this._autoDelete = autoDelete;
        this._id = id;
        this._logSubject = new ExchangeLogSubject(this, this.getVirtualHost());
        CurrentActor.get().message(ExchangeMessages.CREATED(String.valueOf(this.getTypeShortString()), String.valueOf(name), durable));
    }

    @Override
    public boolean isDurable() {
        return this._durable;
    }

    @Override
    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    @Override
    public void close() throws AMQException {
        if (this._closed.compareAndSet(false, true)) {
            if (this._alternateExchange != null) {
                this._alternateExchange.removeReference(this);
            }
            CurrentActor.get().message(this._logSubject, ExchangeMessages.DELETED());
            for (Task task : this._closeTaskList) {
                task.onClose(this);
            }
            this._closeTaskList.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getNameShortString() + "]";
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public QueueRegistry getQueueRegistry() {
        return this.getVirtualHost().getQueueRegistry();
    }

    @Override
    public final boolean isBound(AMQShortString routingKey, FieldTable ft, AMQQueue queue) {
        return this.isBound(routingKey == null ? "" : routingKey.asString(), FieldTable.convertToMap((FieldTable)ft), queue);
    }

    @Override
    public final boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || queue != b.getQueue()) continue;
            return b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : ((Object)b.getArguments()).equals(arguments);
        }
        return false;
    }

    @Override
    public final boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(routingKey == null ? "" : routingKey.asString(), queue);
    }

    @Override
    public final boolean isBound(String bindingKey, AMQQueue queue) {
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey()) || queue != b.getQueue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(AMQShortString routingKey) {
        return this.isBound(routingKey == null ? "" : routingKey.asString());
    }

    @Override
    public final boolean isBound(String bindingKey) {
        for (Binding b : this._bindings) {
            if (!bindingKey.equals(b.getBindingKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(AMQQueue queue) {
        for (Binding b : this._bindings) {
            if (queue != b.getQueue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(Map<String, Object> arguments, AMQQueue queue) {
        for (Binding b : this._bindings) {
            if (queue != b.getQueue() || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : ((Object)b.getArguments()).equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(Map<String, Object> arguments) {
        for (Binding b : this._bindings) {
            if (!(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : ((Object)b.getArguments()).equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isBound(String bindingKey, Map<String, Object> arguments) {
        for (Binding b : this._bindings) {
            if (!b.getBindingKey().equals(bindingKey) || !(b.getArguments() == null || b.getArguments().isEmpty() ? arguments == null || arguments.isEmpty() : ((Object)b.getArguments()).equals(arguments))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    @Override
    public Exchange getAlternateExchange() {
        return this._alternateExchange;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
        if (exchange != null) {
            exchange.addReference(this);
        }
        this._alternateExchange = exchange;
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
        this._referrers.remove(exchange);
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
        this._referrers.put(exchange, Boolean.TRUE);
    }

    @Override
    public boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    public void addCloseTask(Task task) {
        this._closeTaskList.add(task);
    }

    public void removeCloseTask(Task task) {
        this._closeTaskList.remove(task);
    }

    public final void doAddBinding(Binding binding) {
        int maxBindingsSize;
        this._bindings.add(binding);
        int bindingCountSize = this._bindings.size();
        while ((maxBindingsSize = this._bindingCountHigh.get()) < bindingCountSize) {
            this._bindingCountHigh.compareAndSet(maxBindingsSize, bindingCountSize);
        }
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingAdded(this, binding);
        }
        this.onBind(binding);
    }

    public long getBindingCountHigh() {
        return this._bindingCountHigh.get();
    }

    public final void doRemoveBinding(Binding binding) {
        this.onUnbind(binding);
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingRemoved(this, binding);
        }
        this._bindings.remove(binding);
    }

    @Override
    public final Collection<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    protected abstract void onBind(Binding var1);

    protected abstract void onUnbind(Binding var1);

    @Override
    public String getName() {
        return this._name.toString();
    }

    @Override
    public ExchangeType getType() {
        return this._type;
    }

    public Map<String, Object> getArguments() {
        return Collections.emptyMap();
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public final List<? extends BaseQueue> route(InboundMessage message) {
        List<? extends BaseQueue> queues;
        this._receivedMessageCount.incrementAndGet();
        this._receivedMessageSize.addAndGet(message.getSize());
        List<? extends BaseQueue> allQueues = queues = this.doRoute(message);
        boolean deletedQueues = false;
        for (BaseQueue baseQueue : allQueues) {
            if (!baseQueue.isDeleted()) continue;
            if (!deletedQueues) {
                deletedQueues = true;
                queues = new ArrayList<BaseQueue>(allQueues);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange: " + this.getName() + " - attempt to enqueue message onto deleted queue " + String.valueOf(baseQueue.getNameShortString())));
            }
            queues.remove(baseQueue);
        }
        if (!queues.isEmpty()) {
            this._routedMessageCount.incrementAndGet();
            this._routedMessageSize.addAndGet(message.getSize());
        } else {
            this._droppedMessageCount.incrementAndGet();
            this._droppedMessageSize.addAndGet(message.getSize());
        }
        return queues;
    }

    protected abstract List<? extends BaseQueue> doRoute(InboundMessage var1);

    @Override
    public long getMsgReceives() {
        return this._receivedMessageCount.get();
    }

    public long getMsgRoutes() {
        return this._routedMessageCount.get();
    }

    @Override
    public long getMsgDrops() {
        return this._droppedMessageCount.get();
    }

    @Override
    public long getByteReceives() {
        return this._receivedMessageSize.get();
    }

    public long getByteRoutes() {
        return this._routedMessageSize.get();
    }

    @Override
    public long getByteDrops() {
        return this._droppedMessageSize.get();
    }

    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void addBindingListener(Exchange.BindingListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeBindingListener(Exchange.BindingListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public boolean addBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(null, bindingKey, queue, arguments, false, false);
    }

    @Override
    public boolean replaceBinding(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(id, bindingKey, queue, arguments, false, true);
    }

    @Override
    public void restoreBinding(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> argumentMap) throws AMQSecurityException, AMQInternalException {
        this.makeBinding(id, bindingKey, queue, argumentMap, true, false);
    }

    @Override
    public void removeBinding(Binding b) throws AMQSecurityException, AMQInternalException {
        this.removeBinding(b.getBindingKey(), b.getQueue(), b.getArguments());
    }

    @Override
    public Binding removeBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (!this._virtualHost.getSecurityManager().authoriseUnbind(this, new AMQShortString(bindingKey), queue)) {
            throw new AMQSecurityException("Permission denied: unbinding " + bindingKey);
        }
        BindingImpl b = this._bindingsMap.remove(new BindingImpl(null, bindingKey, queue, arguments));
        if (b != null) {
            this.doRemoveBinding(b);
            queue.removeBinding(b);
            this.removeCloseTask(b);
            queue.removeQueueDeleteTask(b);
            if (b.isDurable()) {
                DurableConfigurationStoreHelper.removeBinding(this._virtualHost.getDurableConfigurationStore(), b);
            }
            b.logDestruction();
        }
        return b;
    }

    @Override
    public Binding getBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        BindingImpl b = new BindingImpl(null, bindingKey, queue, arguments);
        return this._bindingsMap.get(b);
    }

    private boolean makeBinding(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> arguments, boolean restore, boolean force) throws AMQSecurityException, AMQInternalException {
        BindingImpl b;
        BindingImpl existingMapping;
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (!this._virtualHost.getSecurityManager().authoriseBind(this, queue, new AMQShortString(bindingKey))) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
        if (id == null) {
            id = UUIDGenerator.generateBindingUUID(this.getName(), queue.getName(), bindingKey, this._virtualHost.getName());
        }
        if ((existingMapping = this._bindingsMap.putIfAbsent(b = new BindingImpl(id, bindingKey, queue, arguments), b)) == null || force) {
            if (existingMapping != null) {
                this.removeBinding(existingMapping);
            }
            if (b.isDurable() && !restore) {
                DurableConfigurationStoreHelper.createBinding(this._virtualHost.getDurableConfigurationStore(), b);
            }
            queue.addQueueDeleteTask(b);
            this.addCloseTask(b);
            queue.addBinding(b);
            this.doAddBinding(b);
            b.logCreation();
            return true;
        }
        return false;
    }

    public static interface Task {
        public void onClose(Exchange var1) throws AMQSecurityException, AMQInternalException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingImpl
    extends Binding
    implements AMQQueue.Task,
    Task {
        private final BindingLogSubject _logSubject;
        private long _createTime;

        private BindingImpl(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> arguments) {
            super(id, bindingKey, queue, AbstractExchange.this, arguments);
            this._createTime = System.currentTimeMillis();
            this._logSubject = new BindingLogSubject(bindingKey, AbstractExchange.this, queue);
        }

        @Override
        public void doTask(AMQQueue queue) throws AMQException {
            AbstractExchange.this.removeBinding(this);
        }

        @Override
        public void onClose(Exchange exchange) throws AMQSecurityException, AMQInternalException {
            AbstractExchange.this.removeBinding(this);
        }

        void logCreation() {
            CurrentActor.get().message(this._logSubject, BindingMessages.CREATED(String.valueOf(this.getArguments()), this.getArguments() != null && !this.getArguments().isEmpty()));
        }

        void logDestruction() {
            CurrentActor.get().message(this._logSubject, BindingMessages.DELETED());
        }

        public String getOrigin() {
            return (String)this.getArguments().get("qpid.fed.origin");
        }

        public long getCreateTime() {
            return this._createTime;
        }

        public boolean isDurable() {
            return this.getQueue().isDurable() && this.getExchange().isDurable();
        }
    }
}

