/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.DirectExchange;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchange
implements Exchange {
    private UUID _id;
    private VirtualHost _virtualHost;
    private static final Logger _logger = Logger.getLogger(DefaultExchange.class);
    private final AtomicBoolean _closed = new AtomicBoolean();
    private LogSubject _logSubject;
    private Map<ExchangeReferrer, Object> _referrers = new ConcurrentHashMap<ExchangeReferrer, Object>();

    @Override
    public void initialise(UUID id, VirtualHost host, AMQShortString name, boolean durable, boolean autoDelete) throws AMQException {
        this._id = id;
        this._virtualHost = host;
    }

    @Override
    public String getName() {
        return ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString();
    }

    @Override
    public ExchangeType getType() {
        return DirectExchange.TYPE;
    }

    @Override
    public long getBindingCount() {
        return this._virtualHost.getQueueRegistry().getQueues().size();
    }

    @Override
    public long getByteDrops() {
        return 0L;
    }

    @Override
    public long getByteReceives() {
        return 0L;
    }

    @Override
    public long getMsgDrops() {
        return 0L;
    }

    @Override
    public long getMsgReceives() {
        return 0L;
    }

    @Override
    public boolean addBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        throw new AMQSecurityException("Cannot add bindings to the default exchange");
    }

    @Override
    public boolean replaceBinding(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        throw new AMQSecurityException("Cannot replace bindings on the default exchange");
    }

    @Override
    public void restoreBinding(UUID id, String bindingKey, AMQQueue queue, Map<String, Object> argumentMap) throws AMQSecurityException, AMQInternalException {
        _logger.warn((Object)"Bindings to the default exchange should not be stored in the configuration store");
    }

    @Override
    public void removeBinding(Binding b) throws AMQSecurityException, AMQInternalException {
        throw new AMQSecurityException("Cannot remove bindings to the default exchange");
    }

    @Override
    public Binding removeBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        throw new AMQSecurityException("Cannot remove bindings to the default exchange");
    }

    @Override
    public Binding getBinding(String bindingKey, AMQQueue queue, Map<String, Object> arguments) {
        if (this._virtualHost.getQueueRegistry().getQueue(bindingKey) == queue && (arguments == null || arguments.isEmpty())) {
            return this.convertToBinding(queue);
        }
        return null;
    }

    private Binding convertToBinding(AMQQueue queue) {
        String queueName = queue.getName();
        UUID exchangeId = UUIDGenerator.generateBindingUUID(ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString(), queueName, queueName, this._virtualHost.getName());
        return new Binding(exchangeId, queueName, queue, this, Collections.EMPTY_MAP);
    }

    @Override
    public AMQShortString getNameShortString() {
        return AMQShortString.EMPTY_STRING;
    }

    @Override
    public AMQShortString getTypeShortString() {
        return this.getType().getName();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public boolean isAutoDelete() {
        return false;
    }

    @Override
    public void close() throws AMQException {
        if (this._closed.compareAndSet(false, true)) {
            CurrentActor.get().message(this._logSubject, ExchangeMessages.DELETED());
        }
    }

    public List<AMQQueue> route(InboundMessage message) {
        AMQQueue q = this._virtualHost.getQueueRegistry().getQueue(message.getRoutingKey());
        if (q == null) {
            List<AMQQueue> noQueues = Collections.emptyList();
            return noQueues;
        }
        return Collections.singletonList(q);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue) && (arguments == null || arguments.isEmpty());
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(routingKey) && this.isBound(queue) && queue.getNameShortString().equals(routingKey);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        return this._virtualHost.getQueueRegistry().getQueue(routingKey) != null;
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        return this._virtualHost.getQueueRegistry().getQueue(queue.getName()) == queue;
    }

    @Override
    public boolean hasBindings() {
        return this.getBindingCount() != 0L;
    }

    @Override
    public boolean isBound(String bindingKey, AMQQueue queue) {
        return this.isBound(queue) && queue.getName().equals(bindingKey);
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        return this.isBound(bindingKey, queue) && (arguments == null || arguments.isEmpty());
    }

    @Override
    public boolean isBound(Map<String, Object> arguments, AMQQueue queue) {
        return (arguments == null || arguments.isEmpty()) && this.isBound(queue);
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments) {
        return (arguments == null || arguments.isEmpty()) && this.isBound(bindingKey);
    }

    @Override
    public boolean isBound(Map<String, Object> arguments) {
        return (arguments == null || arguments.isEmpty()) && this.hasBindings();
    }

    @Override
    public boolean isBound(String bindingKey) {
        return this._virtualHost.getQueueRegistry().getQueue(bindingKey) != null;
    }

    @Override
    public Exchange getAlternateExchange() {
        return null;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        _logger.warn((Object)"Cannot set the alternate exchange for the default exchange");
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
        this._referrers.remove(exchange);
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
        this._referrers.put(exchange, Boolean.TRUE);
    }

    @Override
    public boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    @Override
    public Collection<Binding> getBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (AMQQueue q : this._virtualHost.getQueueRegistry().getQueues()) {
            bindings.add(this.convertToBinding(q));
        }
        return bindings;
    }

    @Override
    public void addBindingListener(Exchange.BindingListener listener) {
        this._virtualHost.getQueueRegistry().addRegistryChangeListener(this.convertListener(listener));
    }

    private QueueRegistry.RegistryChangeListener convertListener(final Exchange.BindingListener listener) {
        return new QueueRegistry.RegistryChangeListener(){

            public void queueRegistered(AMQQueue queue) {
                listener.bindingAdded(DefaultExchange.this, DefaultExchange.this.convertToBinding(queue));
            }

            public void queueUnregistered(AMQQueue queue) {
                listener.bindingRemoved(DefaultExchange.this, DefaultExchange.this.convertToBinding(queue));
            }
        };
    }

    @Override
    public void removeBindingListener(Exchange.BindingListener listener) {
    }

    @Override
    public UUID getId() {
        return this._id;
    }
}

