/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.DefaultExchange;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeInitialiser;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeRegistry
implements ExchangeRegistry {
    private static final Logger LOGGER = Logger.getLogger(DefaultExchangeRegistry.class);
    private ConcurrentMap<String, Exchange> _exchangeMap = new ConcurrentHashMap<String, Exchange>();
    private Exchange _defaultExchange;
    private VirtualHost _host;
    private final Collection<ExchangeRegistry.RegistryChangeListener> _listeners = Collections.synchronizedCollection(new ArrayList());

    public DefaultExchangeRegistry(VirtualHost host) {
        this._host = host;
    }

    @Override
    public void initialise(ExchangeFactory exchangeFactory) throws AMQException {
        new ExchangeInitialiser().initialise(exchangeFactory, this, this.getDurableConfigurationStore());
        this._defaultExchange = new DefaultExchange();
        UUID defaultExchangeId = UUIDGenerator.generateExchangeUUID(ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString(), this._host.getName());
        this._defaultExchange.initialise(defaultExchangeId, this._host, ExchangeDefaults.DEFAULT_EXCHANGE_NAME, false, false);
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._host.getDurableConfigurationStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExchange(Exchange exchange) throws AMQException {
        this._exchangeMap.put(exchange.getNameShortString().toString(), exchange);
        Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
        synchronized (collection) {
            for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                listener.exchangeRegistered(exchange);
            }
        }
    }

    public void setDefaultExchange(Exchange exchange) {
        this._defaultExchange = exchange;
    }

    @Override
    public Exchange getDefaultExchange() {
        return this._defaultExchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExchange(String name, boolean inUse) throws AMQException {
        Exchange exchange = (Exchange)this._exchangeMap.get(name);
        if (exchange == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Unknown exchange " + name, null);
        }
        if (!this._host.getSecurityManager().authoriseDelete(exchange)) {
            throw new AMQSecurityException();
        }
        Exchange e = (Exchange)this._exchangeMap.remove(name);
        if (e != null) {
            e.close();
            Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.exchangeUnregistered(exchange);
                }
            }
        } else {
            throw new AMQException("Unknown exchange " + name);
        }
    }

    @Override
    public Collection<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this._exchangeMap.values());
    }

    @Override
    public void addRegistryChangeListener(ExchangeRegistry.RegistryChangeListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public Exchange getExchange(String name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultExchange();
        }
        return (Exchange)this._exchangeMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAndUnregisterMbeans() {
        for (Exchange exchange : this.getExchanges()) {
            Collection<ExchangeRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (ExchangeRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.exchangeUnregistered(exchange);
                }
            }
        }
        this._exchangeMap.clear();
    }

    @Override
    public synchronized Exchange getExchange(UUID exchangeId) {
        if (exchangeId == null) {
            return this.getDefaultExchange();
        }
        Collection exchanges = this._exchangeMap.values();
        for (Exchange exchange : exchanges) {
            if (!exchange.getId().equals(exchangeId)) continue;
            return exchange;
        }
        return null;
    }

    @Override
    public boolean isReservedExchangeName(String name) {
        if (name == null || ExchangeDefaults.DEFAULT_EXCHANGE_NAME.asString().equals(name) || name.startsWith("amq.") || name.startsWith("qpid.")) {
            return true;
        }
        Collection<ExchangeType<? extends Exchange>> registeredTypes = this._host.getExchangeTypes();
        for (ExchangeType<? extends Exchange> type : registeredTypes) {
            if (!type.getDefaultExchangeName().toString().equals(name)) continue;
            return true;
        }
        return false;
    }
}

