/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.DirectExchangeType;
import org.apache.qpid.server.exchange.FilterSupport;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(DirectExchange.class);
    private final ConcurrentHashMap<String, BindingSet> _bindingsByKey = new ConcurrentHashMap();
    public static final ExchangeType<DirectExchange> TYPE = new DirectExchangeType();

    public DirectExchange() {
        super(TYPE);
    }

    @Override
    public List<? extends BaseQueue> doRoute(InboundMessage payload) {
        String routingKey = payload.getRoutingKey();
        BindingSet bindings = this._bindingsByKey.get(routingKey == null ? "" : routingKey);
        if (bindings != null) {
            List<BaseQueue> queues = bindings.getUnfilteredQueues();
            if (bindings.hasFilteredQueues()) {
                HashSet<BaseQueue> queuesSet = new HashSet<BaseQueue>(queues);
                Map<BaseQueue, MessageFilter> filteredQueues = bindings.getFilteredQueues();
                for (Map.Entry<BaseQueue, MessageFilter> entry : filteredQueues.entrySet()) {
                    MessageFilter filter;
                    if (queuesSet.contains(entry.getKey()) || !(filter = entry.getValue()).matches(payload)) continue;
                    queuesSet.add(entry.getKey());
                }
                if (queues.size() != queuesSet.size()) {
                    queues = new ArrayList<BaseQueue>(queuesSet);
                }
            }
            return queues;
        }
        return Collections.emptyList();
    }

    @Override
    protected void onBind(Binding binding) {
        BindingSet newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf((String)bindingKey);
        assert (queue != null);
        assert (routingKey != null);
        BindingSet bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new BindingSet())) != null) {
            bindings = newBindings;
        }
        bindings.addBinding(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        BindingSet bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.removeBinding(binding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BindingSet {
        private CopyOnWriteArraySet<Binding> _bindings = new CopyOnWriteArraySet();
        private List<BaseQueue> _unfilteredQueues = new ArrayList<BaseQueue>();
        private Map<BaseQueue, MessageFilter> _filteredQueues = new HashMap<BaseQueue, MessageFilter>();

        private BindingSet() {
        }

        public synchronized void addBinding(Binding binding) {
            this._bindings.add(binding);
            this.recalculateQueues();
        }

        public synchronized void removeBinding(Binding binding) {
            this._bindings.remove(binding);
            this.recalculateQueues();
        }

        private void recalculateQueues() {
            ArrayList<BaseQueue> queues = new ArrayList<BaseQueue>(this._bindings.size());
            HashMap<BaseQueue, MessageFilter> filteredQueues = new HashMap<BaseQueue, MessageFilter>();
            for (Binding b : this._bindings) {
                if (FilterSupport.argumentsContainFilter(b.getArguments())) {
                    try {
                        MessageFilter filter = FilterSupport.createMessageFilter(b.getArguments(), b.getQueue());
                        filteredQueues.put(b.getQueue(), filter);
                    }
                    catch (AMQInvalidArgumentException e) {
                        _logger.warn((Object)("Binding ignored: cannot parse filter on binding of queue '" + b.getQueue().getName() + "' to exchange '" + b.getExchange().getName() + "' with arguments: " + b.getArguments()), (Throwable)e);
                    }
                    continue;
                }
                if (queues.contains(b.getQueue())) continue;
                queues.add(b.getQueue());
            }
            this._unfilteredQueues = queues;
            this._filteredQueues = filteredQueues;
        }

        public List<BaseQueue> getUnfilteredQueues() {
            return this._unfilteredQueues;
        }

        public CopyOnWriteArraySet<Binding> getBindings() {
            return this._bindings;
        }

        public boolean hasFilteredQueues() {
            return !this._filteredQueues.isEmpty();
        }

        public Map<BaseQueue, MessageFilter> getFilteredQueues() {
            return this._filteredQueues;
        }
    }
}

