/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Exchange
extends ExchangeReferrer {
    public void initialise(UUID var1, VirtualHost var2, AMQShortString var3, boolean var4, boolean var5) throws AMQException;

    public UUID getId();

    public String getName();

    public AMQShortString getNameShortString();

    public ExchangeType getType();

    public AMQShortString getTypeShortString();

    public boolean isDurable();

    public boolean isAutoDelete();

    public Exchange getAlternateExchange();

    public void setAlternateExchange(Exchange var1);

    public long getBindingCount();

    public long getByteDrops();

    public long getByteReceives();

    public long getMsgDrops();

    public long getMsgReceives();

    public boolean addBinding(String var1, AMQQueue var2, Map<String, Object> var3) throws AMQSecurityException, AMQInternalException;

    public boolean replaceBinding(UUID var1, String var2, AMQQueue var3, Map<String, Object> var4) throws AMQSecurityException, AMQInternalException;

    public void restoreBinding(UUID var1, String var2, AMQQueue var3, Map<String, Object> var4) throws AMQSecurityException, AMQInternalException;

    public void removeBinding(Binding var1) throws AMQSecurityException, AMQInternalException;

    public Binding removeBinding(String var1, AMQQueue var2, Map<String, Object> var3) throws AMQSecurityException, AMQInternalException;

    public Binding getBinding(String var1, AMQQueue var2, Map<String, Object> var3);

    public void close() throws AMQException;

    public List<? extends BaseQueue> route(InboundMessage var1);

    public boolean isBound(AMQShortString var1, FieldTable var2, AMQQueue var3);

    public boolean isBound(AMQShortString var1, AMQQueue var2);

    public boolean isBound(AMQShortString var1);

    public boolean hasBindings();

    public Collection<Binding> getBindings();

    public boolean isBound(String var1);

    public boolean isBound(AMQQueue var1);

    public boolean isBound(Map<String, Object> var1);

    public boolean isBound(String var1, AMQQueue var2);

    public boolean isBound(String var1, Map<String, Object> var2);

    public boolean isBound(Map<String, Object> var1, AMQQueue var2);

    public boolean isBound(String var1, Map<String, Object> var2, AMQQueue var3);

    public void removeReference(ExchangeReferrer var1);

    public void addReference(ExchangeReferrer var1);

    public boolean hasReferrers();

    public void addBindingListener(BindingListener var1);

    public void removeBindingListener(BindingListener var1);

    public static interface BindingListener {
        public void bindingAdded(Exchange var1, Binding var2);

        public void bindingRemoved(Exchange var1, Binding var2);
    }
}

