/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import org.apache.qpid.AMQException;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.DurableConfigurationStoreHelper;

public class ExchangeInitialiser {
    public void initialise(ExchangeFactory factory, ExchangeRegistry registry, DurableConfigurationStore store) throws AMQException {
        for (ExchangeType<? extends Exchange> type : factory.getRegisteredTypes()) {
            this.define(registry, factory, type.getDefaultExchangeName().toString(), type.getName().toString(), store);
        }
    }

    private void define(ExchangeRegistry r, ExchangeFactory f, String name, String type, DurableConfigurationStore store) throws AMQException {
        if (r.getExchange(name) == null) {
            Exchange exchange = f.createExchange(name, type, true, false);
            r.registerExchange(exchange);
            if (exchange.isDurable()) {
                DurableConfigurationStoreHelper.createExchange(store, exchange);
            }
        }
    }
}

