/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSupport {
    private static final Map<String, WeakReference<JMSSelectorFilter>> _selectorCache = Collections.synchronizedMap(new WeakHashMap());

    static MessageFilter createJMSSelectorFilter(FieldTable args) throws AMQInvalidArgumentException {
        String selectorString = args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue());
        return FilterSupport.getMessageFilter(selectorString);
    }

    static MessageFilter createJMSSelectorFilter(Map<String, Object> args) throws AMQInvalidArgumentException {
        String selectorString = (String)args.get(AMQPFilterTypes.JMS_SELECTOR.toString());
        return FilterSupport.getMessageFilter(selectorString);
    }

    private static MessageFilter getMessageFilter(String selectorString) throws AMQInvalidArgumentException {
        WeakReference<JMSSelectorFilter> selectorRef = _selectorCache.get(selectorString);
        JMSSelectorFilter selector = null;
        if (selectorRef == null || (selector = (JMSSelectorFilter)selectorRef.get()) == null) {
            try {
                selector = new JMSSelectorFilter(selectorString);
            }
            catch (ParseException e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            catch (SelectorParsingException e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            catch (TokenMgrError e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            _selectorCache.put(selectorString, new WeakReference<JMSSelectorFilter>(selector));
        }
        return selector;
    }

    static boolean argumentsContainFilter(FieldTable args) {
        return FilterSupport.argumentsContainNoLocal(args) || FilterSupport.argumentsContainJMSSelector(args);
    }

    public static boolean argumentsContainFilter(Map<String, Object> args) {
        return FilterSupport.argumentsContainNoLocal(args) || FilterSupport.argumentsContainJMSSelector(args);
    }

    public static void removeFilters(Map<String, Object> args) {
        args.remove(AMQPFilterTypes.JMS_SELECTOR.toString());
        args.remove(AMQPFilterTypes.NO_LOCAL.toString());
    }

    static boolean argumentsContainNoLocal(Map<String, Object> args) {
        return args != null && args.containsKey(AMQPFilterTypes.NO_LOCAL.toString()) && Boolean.TRUE.equals(args.get(AMQPFilterTypes.NO_LOCAL.toString()));
    }

    static boolean argumentsContainNoLocal(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.NO_LOCAL.getValue()) && Boolean.TRUE.equals(args.get(AMQPFilterTypes.NO_LOCAL.getValue()));
    }

    static boolean argumentsContainJMSSelector(Map<String, Object> args) {
        return args != null && args.get(AMQPFilterTypes.JMS_SELECTOR.toString()) instanceof String && ((String)args.get(AMQPFilterTypes.JMS_SELECTOR.toString())).trim().length() != 0;
    }

    static boolean argumentsContainJMSSelector(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue()).trim().length() != 0;
    }

    static MessageFilter createMessageFilter(Map<String, Object> args, AMQQueue queue) throws AMQInvalidArgumentException {
        if (FilterSupport.argumentsContainNoLocal(args)) {
            MessageFilter filter = new NoLocalFilter(queue);
            if (FilterSupport.argumentsContainJMSSelector(args)) {
                filter = new CompoundFilter(filter, FilterSupport.createJMSSelectorFilter(args));
            }
            return filter;
        }
        return FilterSupport.createJMSSelectorFilter(args);
    }

    static MessageFilter createMessageFilter(FieldTable args, AMQQueue queue) throws AMQInvalidArgumentException {
        if (FilterSupport.argumentsContainNoLocal(args)) {
            MessageFilter filter = new NoLocalFilter(queue);
            if (FilterSupport.argumentsContainJMSSelector(args)) {
                filter = new CompoundFilter(filter, FilterSupport.createJMSSelectorFilter(args));
            }
            return filter;
        }
        return FilterSupport.createJMSSelectorFilter(args);
    }

    static final class CompoundFilter
    implements MessageFilter {
        private MessageFilter _noLocalFilter;
        private MessageFilter _jmsSelectorFilter;

        public CompoundFilter(MessageFilter filter, MessageFilter jmsSelectorFilter) {
            this._noLocalFilter = filter;
            this._jmsSelectorFilter = jmsSelectorFilter;
        }

        public boolean matches(Filterable message) {
            return this._noLocalFilter.matches(message) && this._jmsSelectorFilter.matches(message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundFilter that = (CompoundFilter)o;
            if (this._jmsSelectorFilter != null ? !this._jmsSelectorFilter.equals(that._jmsSelectorFilter) : that._jmsSelectorFilter != null) {
                return false;
            }
            return !(this._noLocalFilter != null ? !this._noLocalFilter.equals(that._noLocalFilter) : that._noLocalFilter != null);
        }

        public int hashCode() {
            int result = this._noLocalFilter != null ? this._noLocalFilter.hashCode() : 0;
            result = 31 * result + (this._jmsSelectorFilter != null ? this._jmsSelectorFilter.hashCode() : 0);
            return result;
        }
    }

    static final class NoLocalFilter
    implements MessageFilter {
        private final AMQQueue _queue;

        public NoLocalFilter(AMQQueue queue) {
            this._queue = queue;
        }

        public boolean matches(Filterable message) {
            InboundMessage inbound = (InboundMessage)message;
            AMQSessionModel exclusiveOwningSession = this._queue.getExclusiveOwningSession();
            return exclusiveOwningSession == null || !exclusiveOwningSession.onSameConnection(inbound);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoLocalFilter that = (NoLocalFilter)o;
            return this._queue == null ? that._queue == null : this._queue.equals(that._queue);
        }

        public int hashCode() {
            return this._queue != null ? this._queue.hashCode() : 0;
        }
    }
}

