/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.exchange.HeadersExchangeType;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(HeadersExchange.class);
    private final ConcurrentHashMap<String, CopyOnWriteArraySet<Binding>> _bindingsByKey = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HeadersBinding> _bindingHeaderMatchers = new CopyOnWriteArrayList();
    public static final ExchangeType<HeadersExchange> TYPE = new HeadersExchangeType();

    public HeadersExchange() {
        super(TYPE);
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": routing message with headers " + payload.getMessageHeader()));
        }
        LinkedHashSet<AMQQueue> queues = new LinkedHashSet<AMQQueue>();
        for (HeadersBinding hb : this._bindingHeaderMatchers) {
            if (!hb.matches(payload)) continue;
            Binding b = hb.getBinding();
            b.incrementMatches();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange " + this.getNameShortString() + ": delivering message with headers " + payload.getMessageHeader() + " to " + b.getQueue().getNameShortString()));
            }
            queues.add(b.getQueue());
        }
        return new ArrayList<BaseQueue>(queues);
    }

    @Override
    protected void onBind(Binding binding) {
        CopyOnWriteArraySet<Binding> newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf((String)bindingKey);
        Map<String, Object> args = binding.getArguments();
        assert (queue != null);
        assert (routingKey != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new CopyOnWriteArraySet())) != null) {
            bindings = newBindings;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": Binding " + queue.getNameShortString() + " with binding key '" + bindingKey + "' and args: " + args));
        }
        this._bindingHeaderMatchers.add(new HeadersBinding(binding));
        bindings.add(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.remove(binding);
        }
        boolean removedBinding = this._bindingHeaderMatchers.remove(new HeadersBinding(binding));
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Removing Binding: " + removedBinding));
        }
    }
}

