/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.subjects;

import java.text.MessageFormat;
import org.apache.qpid.server.logging.subjects.AbstractLogSubject;
import org.apache.qpid.server.protocol.AMQConnectionModel;

public class ConnectionLogSubject
extends AbstractLogSubject {
    private AMQConnectionModel _session;
    private boolean _upToDate = false;

    public ConnectionLogSubject(AMQConnectionModel session) {
        this._session = session;
    }

    private void updateLogString() {
        if (!this._upToDate) {
            if (this._session.getPrincipalAsString() != null) {
                if (this._session.getVirtualHostName() != null) {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this._session.getConnectionId(), this._session.getPrincipalAsString(), this._session.getRemoteAddressString(), this._session.getVirtualHostName()) + "] ");
                    this._upToDate = true;
                } else {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2})", this._session.getConnectionId(), this._session.getPrincipalAsString(), this._session.getRemoteAddressString()) + "] ");
                }
            } else {
                this.setLogString("[" + MessageFormat.format("con:{0}({1})", this._session.getConnectionId(), this._session.getRemoteAddressString()) + "] ");
            }
        }
    }

    public String toLogString() {
        this.updateLogString();
        return super.toLogString();
    }
}

