/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Port
extends ConfiguredObject {
    public static final String CREATED = "created";
    public static final String DURABLE = "durable";
    public static final String ID = "id";
    public static final String LIFETIME_POLICY = "lifetimePolicy";
    public static final String NAME = "name";
    public static final String STATE = "state";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String UPDATED = "updated";
    public static final String BINDING_ADDRESS = "bindingAddress";
    public static final String PORT = "port";
    public static final String PROTOCOLS = "protocols";
    public static final String TRANSPORTS = "transports";
    public static final String TCP_NO_DELAY = "tcpNoDelay";
    public static final String SEND_BUFFER_SIZE = "sendBufferSize";
    public static final String RECEIVE_BUFFER_SIZE = "receiveBufferSize";
    public static final String NEED_CLIENT_AUTH = "needClientAuth";
    public static final String WANT_CLIENT_AUTH = "wantClientAuth";
    public static final String AUTHENTICATION_PROVIDER = "authenticationProvider";
    public static final String KEY_STORE = "keyStore";
    public static final String TRUST_STORES = "trustStores";
    public static final Collection<String> AVAILABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("id", "name", "state", "durable", "lifetimePolicy", "timeToLive", "created", "updated", "bindingAddress", "port", "protocols", "transports", "tcpNoDelay", "sendBufferSize", "receiveBufferSize", "needClientAuth", "wantClientAuth", "authenticationProvider", "keyStore", "trustStores"));

    public String getBindingAddress();

    public int getPort();

    public KeyStore getKeyStore();

    public Collection<TrustStore> getTrustStores();

    public Collection<Transport> getTransports();

    public void addTransport(Transport var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    public Transport removeTransport(Transport var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    public Collection<Protocol> getProtocols();

    public void addProtocol(Protocol var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    public Protocol removeProtocol(Protocol var1) throws IllegalStateException, AccessControlException, IllegalArgumentException;

    public AuthenticationProvider getAuthenticationProvider();

    public Collection<VirtualHostAlias> getVirtualHostBindings();

    public Collection<Connection> getConnections();
}

