/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Protocol {
    AMQP_0_8(ProtocolType.AMQP),
    AMQP_0_9(ProtocolType.AMQP),
    AMQP_0_9_1(ProtocolType.AMQP),
    AMQP_0_10(ProtocolType.AMQP),
    AMQP_1_0(ProtocolType.AMQP),
    JMX_RMI(ProtocolType.JMX),
    HTTP(ProtocolType.HTTP),
    RMI(ProtocolType.RMI);

    private final ProtocolType _protocolType;

    private Protocol(ProtocolType type) {
        this._protocolType = type;
    }

    public ProtocolType getProtocolType() {
        return this._protocolType;
    }

    public boolean isAMQP() {
        return this._protocolType == ProtocolType.AMQP;
    }

    public AmqpProtocolVersion toAmqpProtocolVersion() {
        switch (this) {
            case AMQP_0_8: {
                return AmqpProtocolVersion.v0_8;
            }
            case AMQP_0_9: {
                return AmqpProtocolVersion.v0_9;
            }
            case AMQP_0_9_1: {
                return AmqpProtocolVersion.v0_9_1;
            }
            case AMQP_0_10: {
                return AmqpProtocolVersion.v0_10;
            }
            case AMQP_1_0: {
                return AmqpProtocolVersion.v1_0_0;
            }
        }
        throw new IllegalArgumentException((Object)((Object)this) + " is not an known AMQP protocol");
    }

    public static Protocol valueOfObject(Object protocolObject) {
        Protocol protocol;
        if (protocolObject instanceof Protocol) {
            protocol = (Protocol)((Object)protocolObject);
        } else {
            try {
                protocol = Protocol.valueOf(String.valueOf(protocolObject));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't convert '" + protocolObject + "' to one of the supported protocols: " + EnumSet.allOf(Protocol.class), e);
            }
        }
        return protocol;
    }

    public static boolean hasAmqpProtocol(Collection<Protocol> protocols) {
        for (Protocol protocol : protocols) {
            if (!protocol.isAMQP()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtocolType {
        AMQP,
        HTTP,
        JMX,
        RMI;

    }
}

