/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.store.MessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VirtualHost
extends ConfiguredObject {
    public static final String BYTES_IN = "bytesIn";
    public static final String BYTES_OUT = "bytesOut";
    public static final String BYTES_RETAINED = "bytesRetained";
    public static final String LOCAL_TRANSACTION_BEGINS = "localTransactionBegins";
    public static final String LOCAL_TRANSACTION_ROLLBACKS = "localTransactionRollbacks";
    public static final String MESSAGES_IN = "messagesIn";
    public static final String MESSAGES_OUT = "messagesOut";
    public static final String MESSAGES_RETAINED = "messagesRetained";
    public static final String STATE_CHANGED = "stateChanged";
    public static final String XA_TRANSACTION_BRANCH_ENDS = "xaTransactionBranchEnds";
    public static final String XA_TRANSACTION_BRANCH_STARTS = "xaTransactionBranchStarts";
    public static final String XA_TRANSACTION_BRANCH_SUSPENDS = "xaTransactionBranchSuspends";
    public static final String QUEUE_COUNT = "queueCount";
    public static final String EXCHANGE_COUNT = "exchangeCount";
    public static final String CONNECTION_COUNT = "connectionCount";
    public static final Collection<String> AVAILABLE_STATISTICS = Collections.unmodifiableList(Arrays.asList("bytesIn", "bytesOut", "bytesRetained", "localTransactionBegins", "localTransactionRollbacks", "messagesIn", "messagesOut", "messagesRetained", "stateChanged", "xaTransactionBranchEnds", "xaTransactionBranchStarts", "xaTransactionBranchSuspends", "queueCount", "exchangeCount", "connectionCount"));
    public static final String QUEUE_ALERT_REPEAT_GAP = "queue.alertRepeatGap";
    public static final String QUEUE_ALERT_THRESHOLD_MESSAGE_AGE = "queue.alertThresholdMessageAge";
    public static final String QUEUE_ALERT_THRESHOLD_MESSAGE_SIZE = "queue.alertThresholdMessageSize";
    public static final String QUEUE_ALERT_THRESHOLD_QUEUE_DEPTH_BYTES = "queue.alertThresholdQueueDepthBytes";
    public static final String QUEUE_ALERT_THRESHOLD_QUEUE_DEPTH_MESSAGES = "queue.alertThresholdQueueDepthMessages";
    public static final String QUEUE_DEAD_LETTER_QUEUE_ENABLED = "queue.deadLetterQueueEnabled";
    public static final String QUEUE_MAXIMUM_DELIVERY_ATTEMPTS = "queue.maximumDeliveryAttempts";
    public static final String QUEUE_FLOW_CONTROL_SIZE_BYTES = "queue.flowControlSizeBytes";
    public static final String QUEUE_FLOW_RESUME_SIZE_BYTES = "queue.flowResumeSizeBytes";
    public static final String HOUSEKEEPING_CHECK_PERIOD = "housekeepingCheckPeriod";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = "storeTransactionIdleTimeoutClose";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_WARN = "storeTransactionIdleTimeoutWarn";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = "storeTransactionOpenTimeoutClose";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_WARN = "storeTransactionOpenTimeoutWarn";
    public static final String STORE_TYPE = "storeType";
    public static final String STORE_PATH = "storePath";
    public static final String SUPPORTED_EXCHANGE_TYPES = "supportedExchangeTypes";
    public static final String SUPPORTED_QUEUE_TYPES = "supportedQueueTypes";
    public static final String CREATED = "created";
    public static final String DURABLE = "durable";
    public static final String ID = "id";
    public static final String LIFETIME_POLICY = "lifetimePolicy";
    public static final String NAME = "name";
    public static final String STATE = "state";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String TYPE = "type";
    public static final String UPDATED = "updated";
    public static final String CONFIG_PATH = "configPath";
    public static final Collection<String> AVAILABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("id", "name", "type", "state", "durable", "lifetimePolicy", "timeToLive", "created", "updated", "supportedExchangeTypes", "supportedQueueTypes", "queue.deadLetterQueueEnabled", "housekeepingCheckPeriod", "queue.maximumDeliveryAttempts", "queue.flowControlSizeBytes", "queue.flowResumeSizeBytes", "storeType", "storePath", "storeTransactionIdleTimeoutClose", "storeTransactionIdleTimeoutWarn", "storeTransactionOpenTimeoutClose", "storeTransactionOpenTimeoutWarn", "queue.alertRepeatGap", "queue.alertThresholdMessageAge", "queue.alertThresholdMessageSize", "queue.alertThresholdQueueDepthBytes", "queue.alertThresholdQueueDepthMessages", "configPath"));
    public static final int CURRENT_CONFIG_VERSION = 1;

    public Collection<VirtualHostAlias> getAliases();

    public Collection<Connection> getConnections();

    public Collection<Queue> getQueues();

    public Collection<Exchange> getExchanges();

    public Exchange createExchange(String var1, State var2, boolean var3, LifetimePolicy var4, long var5, String var7, Map<String, Object> var8) throws AccessControlException, IllegalArgumentException;

    public Queue createQueue(String var1, State var2, boolean var3, boolean var4, LifetimePolicy var5, long var6, Map<String, Object> var8) throws AccessControlException, IllegalArgumentException;

    public Collection<String> getExchangeTypes();

    public void executeTransaction(TransactionalOperation var1);

    public SecurityManager getSecurityManager();

    public MessageStore getMessageStore();

    public String getType();

    public static interface TransactionalOperation {
        public void withinTransaction(Transaction var1);
    }

    public static interface Transaction {
        public void dequeue(QueueEntry var1);

        public void copy(QueueEntry var1, Queue var2);

        public void move(QueueEntry var1, Queue var2);
    }
}

