/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyStoreAdapter
extends AbstractAdapter {
    public static final String DUMMY_PASSWORD_MASK = "********";
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    private String _name;
    private String _password;

    protected AbstractKeyStoreAdapter(UUID id, Broker broker, Map<String, Object> defaults, Map<String, Object> attributes) {
        super(id, defaults, attributes, broker.getTaskExecutor());
        this.addParent(Broker.class, broker);
        this._name = MapValueConverter.getStringAttribute("name", attributes);
        this._password = MapValueConverter.getStringAttribute("password", attributes);
        MapValueConverter.assertMandatoryAttribute("path", attributes);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        return State.ACTIVE;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("state".equals(name)) {
            return this.getActualState();
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return this.getLifetimePolicy();
        }
        if ("timeToLive".equals(name)) {
            return this.getTimeToLive();
        }
        if (!"created".equals(name) && !"updated".equals(name) && "password".equals(name)) {
            if (this.getPassword() != null) {
                return DUMMY_PASSWORD_MASK;
            }
            return null;
        }
        return super.getAttribute(name);
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }
}

