/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.plugin.AccessControlFactory;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlProviderAdapter
extends AbstractAdapter
implements AccessControlProvider {
    private static final Logger LOGGER = Logger.getLogger(AccessControlProviderAdapter.class);
    protected AccessControl _accessControl;
    protected final Broker _broker;
    protected Collection<String> _supportedAttributes;
    protected Map<String, AccessControlFactory> _factories;
    private AtomicReference<State> _state;

    public AccessControlProviderAdapter(UUID id, Broker broker, AccessControl accessControl, Map<String, Object> attributes, Collection<String> attributeNames) {
        super(id, null, null, broker.getTaskExecutor());
        if (accessControl == null) {
            throw new IllegalArgumentException("AccessControl must not be null");
        }
        this._accessControl = accessControl;
        this._broker = broker;
        this._supportedAttributes = this.createSupportedAttributes(attributeNames);
        this.addParent(Broker.class, broker);
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.INITIALISING);
        this._state = new AtomicReference<State>(state);
        if (attributes != null) {
            for (String name : this._supportedAttributes) {
                if (!attributes.containsKey(name)) continue;
                this.changeAttribute(name, null, attributes.get(name));
            }
        }
    }

    protected Collection<String> createSupportedAttributes(Collection<String> factoryAttributes) {
        ArrayList<String> attributesNames = new ArrayList<String>(AVAILABLE_ATTRIBUTES);
        if (factoryAttributes != null) {
            attributesNames.addAll(factoryAttributes);
        }
        return Collections.unmodifiableCollection(attributesNames);
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return this._state.get();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return this._supportedAttributes;
    }

    @Override
    public Object getAttribute(String name) {
        if (!"created".equals(name)) {
            if ("durable".equals(name)) {
                return true;
            }
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.PERMANENT;
            }
            if ("state".equals(name)) {
                return this.getActualState();
            }
            if ("timeToLive".equals(name) || "updated".equals(name)) {
                // empty if block
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public boolean setState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        block9: {
            State state = this._state.get();
            if (desiredState == State.DELETED) {
                return this._state.compareAndSet(state, State.DELETED);
            }
            if (desiredState == State.QUIESCED) {
                return this._state.compareAndSet(state, State.QUIESCED);
            }
            if (desiredState == State.ACTIVE) {
                if ((state == State.INITIALISING || state == State.QUIESCED) && this._state.compareAndSet(state, State.ACTIVE)) {
                    try {
                        this._accessControl.open();
                        return true;
                    }
                    catch (RuntimeException e) {
                        this._state.compareAndSet(State.ACTIVE, State.ERRORED);
                        if (this._broker.isManagementMode()) {
                            LOGGER.warn((Object)("Failed to activate ACL provider: " + this.getName()), (Throwable)e);
                            break block9;
                        }
                        throw e;
                    }
                }
                throw new IllegalStateException("Can't activate access control provider in " + (Object)((Object)state) + " state");
            }
            if (desiredState == State.STOPPED) {
                if (this._state.compareAndSet(state, State.STOPPED)) {
                    this._accessControl.close();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        throw new UnsupportedOperationException("Changing attributes on AccessControlProvider is not supported");
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AccessControlProvider.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of AccessControlProvider is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AccessControlProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of AccessControlProvider attributes is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AccessControlProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of AccessControlProvider attributes is denied");
        }
    }

    @Override
    public AccessControl getAccessControl() {
        return this._accessControl;
    }
}

