/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.adapter.PortAdapter;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngineFactory;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.NetworkTransportConfiguration;
import org.apache.qpid.transport.network.IncomingNetworkTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmqpPortAdapter
extends PortAdapter {
    private final Broker _broker;
    private IncomingNetworkTransport _transport;

    public AmqpPortAdapter(UUID id, Broker broker, Map<String, Object> attributes, Map<String, Object> defaultAttributes, TaskExecutor taskExecutor) {
        super(id, broker, attributes, defaultAttributes, taskExecutor);
        this._broker = broker;
    }

    @Override
    protected void onActivate() {
        Collection<Transport> transports = this.getTransports();
        Set<AmqpProtocolVersion> supported = this.convertFromModelProtocolsToAmqp(this.getProtocols());
        SSLContext sslContext = null;
        if (transports.contains((Object)Transport.SSL)) {
            sslContext = this.createSslContext();
        }
        AmqpProtocolVersion defaultSupportedProtocolReply = this.getDefaultAmqpSupportedReply();
        String bindingAddress = (String)this.getAttribute("bindingAddress");
        if ("*".equals(bindingAddress)) {
            bindingAddress = null;
        }
        Integer port = (Integer)this.getAttribute("port");
        InetSocketAddress bindingSocketAddress = null;
        bindingSocketAddress = bindingAddress == null ? new InetSocketAddress(port) : new InetSocketAddress(bindingAddress, (int)port);
        ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(bindingSocketAddress, (Boolean)this.getAttribute("tcpNoDelay"), (Integer)this.getAttribute("sendBufferSize"), (Integer)this.getAttribute("receiveBufferSize"), (Boolean)this.getAttribute("needClientAuth"), (Boolean)this.getAttribute("wantClientAuth"));
        this._transport = org.apache.qpid.transport.network.Transport.getIncomingTransportInstance();
        MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(this._broker, transports.contains((Object)Transport.TCP) ? sslContext : null, settings.wantClientAuth(), settings.needClientAuth(), supported, defaultSupportedProtocolReply, this, transports.contains((Object)Transport.TCP) ? Transport.TCP : Transport.SSL);
        this._transport.accept((NetworkTransportConfiguration)settings, (ProtocolEngineFactory)protocolEngineFactory, transports.contains((Object)Transport.TCP) ? null : sslContext);
        for (Transport transport : this.getTransports()) {
            CurrentActor.get().message(BrokerMessages.LISTENING(String.valueOf((Object)transport), this.getPort()));
        }
    }

    @Override
    protected void onStop() {
        if (this._transport != null) {
            for (Transport transport : this.getTransports()) {
                CurrentActor.get().message(BrokerMessages.SHUTTING_DOWN(String.valueOf((Object)transport), this.getPort()));
            }
            this._transport.close();
        }
    }

    private Set<AmqpProtocolVersion> convertFromModelProtocolsToAmqp(Collection<Protocol> modelProtocols) {
        HashSet<AmqpProtocolVersion> amqpProtocols = new HashSet<AmqpProtocolVersion>();
        for (Protocol protocol : modelProtocols) {
            amqpProtocols.add(protocol.toAmqpProtocolVersion());
        }
        return amqpProtocols;
    }

    private SSLContext createSslContext() {
        SSLContext sslContext;
        boolean needClientCert;
        KeyStore keyStore = this.getKeyStore();
        Collection<TrustStore> trustStores = this.getTrustStores();
        boolean bl = needClientCert = (Boolean)this.getAttribute("needClientAuth") != false || (Boolean)this.getAttribute("wantClientAuth") != false;
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException("Client certificate authentication is enabled on AMQP port '" + this.getName() + "' but no trust store defined");
        }
        String keystorePath = (String)keyStore.getAttribute("path");
        String keystorePassword = keyStore.getPassword();
        String keystoreType = (String)keyStore.getAttribute("type");
        String keyManagerFactoryAlgorithm = (String)keyStore.getAttribute("keyManagerFactoryAlgorithm");
        String certAlias = (String)keyStore.getAttribute("certificateAlias");
        try {
            if (!trustStores.isEmpty()) {
                ArrayList<SSLContextFactory.TrustStoreWrapper> trstWrappers = new ArrayList<SSLContextFactory.TrustStoreWrapper>();
                for (TrustStore trustStore : trustStores) {
                    trstWrappers.add(new SSLContextFactory.TrustStoreWrapper((String)trustStore.getAttribute("path"), trustStore.getPassword(), (String)trustStore.getAttribute("type"), (Boolean)trustStore.getAttribute("peersOnly"), (String)trustStore.getAttribute("trustManagerFactoryAlgorithm")));
                }
                sslContext = SSLContextFactory.buildClientContext(trstWrappers, (String)keystorePath, (String)keystorePassword, (String)keystoreType, (String)keyManagerFactoryAlgorithm, (String)certAlias);
            } else {
                sslContext = SSLContextFactory.buildServerContext((String)keystorePath, (String)keystorePassword, (String)keystoreType, (String)keyManagerFactoryAlgorithm);
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to create SSLContext for key or trust store", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create SSLContext - unable to load key/trust store", e);
        }
        return sslContext;
    }

    private AmqpProtocolVersion getDefaultAmqpSupportedReply() {
        String defaultAmqpSupportedReply = System.getProperty("qpid.broker_default_supported_protocol_version_reply");
        if (defaultAmqpSupportedReply != null) {
            return AmqpProtocolVersion.valueOf(defaultAmqpSupportedReply);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class ServerNetworkTransportConfiguration
    implements NetworkTransportConfiguration {
        private final InetSocketAddress _bindingSocketAddress;
        private final Boolean _tcpNoDelay;
        private final Integer _sendBufferSize;
        private final Integer _receiveBufferSize;
        private final boolean _needClientAuth;
        private final boolean _wantClientAuth;

        public ServerNetworkTransportConfiguration(InetSocketAddress bindingSocketAddress, boolean tcpNoDelay, int sendBufferSize, int receiveBufferSize, boolean needClientAuth, boolean wantClientAuth) {
            this._bindingSocketAddress = bindingSocketAddress;
            this._tcpNoDelay = tcpNoDelay;
            this._sendBufferSize = sendBufferSize;
            this._receiveBufferSize = receiveBufferSize;
            this._needClientAuth = needClientAuth;
            this._wantClientAuth = wantClientAuth;
        }

        public boolean wantClientAuth() {
            return this._wantClientAuth;
        }

        public boolean needClientAuth() {
            return this._needClientAuth;
        }

        public Boolean getTcpNoDelay() {
            return this._tcpNoDelay;
        }

        public Integer getSendBufferSize() {
            return this._sendBufferSize;
        }

        public Integer getReceiveBufferSize() {
            return this._receiveBufferSize;
        }

        public InetSocketAddress getAddress() {
            return this._bindingSocketAddress;
        }
    }
}

