/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticationProviderAdapter<T extends AuthenticationManager>
extends AbstractAdapter
implements AuthenticationProvider {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationProviderAdapter.class);
    protected T _authManager;
    protected final Broker _broker;
    protected Collection<String> _supportedAttributes;
    protected Map<String, AuthenticationManagerFactory> _factories;
    private AtomicReference<State> _state;

    private AuthenticationProviderAdapter(UUID id, Broker broker, T authManager, Map<String, Object> attributes, Collection<String> attributeNames) {
        super(id, null, null, broker.getTaskExecutor());
        this._authManager = authManager;
        this._broker = broker;
        this._supportedAttributes = this.createSupportedAttributes(attributeNames);
        this._factories = this.getAuthenticationManagerFactories();
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.INITIALISING);
        this._state = new AtomicReference<State>(state);
        this.addParent(Broker.class, broker);
        if (attributes != null) {
            for (String name : this._supportedAttributes) {
                if (!attributes.containsKey(name)) continue;
                this.changeAttribute(name, null, attributes.get(name));
            }
        }
    }

    T getAuthManager() {
        return this._authManager;
    }

    @Override
    public Collection<VirtualHostAlias> getVirtualHostPortBindings() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return this._state.get();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return this._supportedAttributes;
    }

    @Override
    public Object getAttribute(String name) {
        if (!"created".equals(name)) {
            if ("durable".equals(name)) {
                return true;
            }
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.PERMANENT;
            }
            if ("state".equals(name)) {
                return this.getActualState();
            }
            if ("timeToLive".equals(name) || "updated".equals(name)) {
                // empty if block
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public boolean setState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        block13: {
            State state = this._state.get();
            if (desiredState == State.DELETED) {
                String providerName = this.getName();
                ArrayList<Port> ports = new ArrayList<Port>(this._broker.getPorts());
                for (Port port : ports) {
                    if (!providerName.equals(port.getAttribute("authenticationProvider"))) continue;
                    throw new IntegrityViolationException("Authentication provider '" + providerName + "' is set on port " + port.getName());
                }
                if ((state == State.INITIALISING || state == State.ACTIVE || state == State.STOPPED || state == State.QUIESCED || state == State.ERRORED) && this._state.compareAndSet(state, State.DELETED)) {
                    this._authManager.close();
                    this._authManager.onDelete();
                    return true;
                }
                throw new IllegalStateException("Cannot delete authentication provider in state: " + (Object)((Object)state));
            }
            if (desiredState == State.ACTIVE) {
                if ((state == State.INITIALISING || state == State.QUIESCED || state == State.STOPPED) && this._state.compareAndSet(state, State.ACTIVE)) {
                    try {
                        this._authManager.initialise();
                        return true;
                    }
                    catch (RuntimeException e) {
                        this._state.compareAndSet(State.ACTIVE, State.ERRORED);
                        if (this._broker.isManagementMode()) {
                            LOGGER.warn((Object)("Failed to activate authentication provider: " + this.getName()), (Throwable)e);
                            break block13;
                        }
                        throw e;
                    }
                }
                throw new IllegalStateException("Cannot activate authentication provider in state: " + (Object)((Object)state));
            }
            if (desiredState == State.QUIESCED) {
                if (state == State.INITIALISING && this._state.compareAndSet(state, State.QUIESCED)) {
                    return true;
                }
            } else if (desiredState == State.STOPPED) {
                if (this._state.compareAndSet(state, State.STOPPED)) {
                    this._authManager.close();
                    return true;
                }
                throw new IllegalStateException("Cannot stop authentication provider in state: " + (Object)((Object)state));
            }
        }
        return false;
    }

    @Override
    public SubjectCreator getSubjectCreator() {
        return new SubjectCreator((AuthenticationManager)this._authManager, this._broker.getGroupProviders());
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        Map<String, Object> effectiveAttributes = super.generateEffectiveAttributes(attributes);
        AuthenticationManager manager = this.validateAttributes(effectiveAttributes);
        manager.initialise();
        super.changeAttributes(attributes);
        this._authManager = manager;
        this._state.compareAndSet(State.ERRORED, State.ACTIVE);
    }

    private Map<String, AuthenticationManagerFactory> getAuthenticationManagerFactories() {
        QpidServiceLoader<AuthenticationManagerFactory> loader = new QpidServiceLoader<AuthenticationManagerFactory>();
        Iterable<AuthenticationManagerFactory> factories = loader.atLeastOneInstanceOf(AuthenticationManagerFactory.class);
        HashMap<String, AuthenticationManagerFactory> factoryMap = new HashMap<String, AuthenticationManagerFactory>();
        for (AuthenticationManagerFactory factory : factories) {
            factoryMap.put(factory.getType(), factory);
        }
        return factoryMap;
    }

    protected Collection<String> createSupportedAttributes(Collection<String> factoryAttributes) {
        ArrayList<String> attributesNames = new ArrayList<String>(AVAILABLE_ATTRIBUTES);
        if (factoryAttributes != null) {
            attributesNames.addAll(factoryAttributes);
        }
        return Collections.unmodifiableCollection(attributesNames);
    }

    protected AuthenticationManager validateAttributes(Map<String, Object> attributes) {
        super.validateChangeAttributes(attributes);
        String newName = (String)attributes.get("name");
        String currentName = this.getName();
        if (!currentName.equals(newName)) {
            throw new IllegalConfigurationException("Changing the name of authentication provider is not supported");
        }
        String newType = (String)attributes.get("type");
        String currentType = (String)this.getAttribute("type");
        if (!currentType.equals(newType)) {
            throw new IllegalConfigurationException("Changing the type of authentication provider is not supported");
        }
        AuthenticationManagerFactory managerFactory = this._factories.get(newType);
        if (managerFactory == null) {
            throw new IllegalConfigurationException("Cannot find authentication provider factory for type " + newType);
        }
        AuthenticationManager manager = managerFactory.createInstance(attributes);
        if (manager == null) {
            throw new IllegalConfigurationException("Cannot change authentication provider " + newName + " of type " + newType + " with the given attributes");
        }
        return manager;
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AuthenticationProvider.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of authentication provider is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AuthenticationProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of authentication provider attributes is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AuthenticationProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of authentication provider attributes is denied");
        }
    }

    /* synthetic */ AuthenticationProviderAdapter(UUID x0, Broker x1, AuthenticationManager x2, Map x3, Collection x4, 1 x5) {
        this(x0, x1, x2, x3, x4);
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrincipalDatabaseAuthenticationManagerAdapter
    extends AuthenticationProviderAdapter<PrincipalDatabaseAuthenticationManager>
    implements PasswordCredentialManagingAuthenticationProvider {
        public PrincipalDatabaseAuthenticationManagerAdapter(UUID id, Broker broker, PrincipalDatabaseAuthenticationManager authManager, Map<String, Object> attributes, Collection<String> attributeNames) {
            super(id, broker, authManager, attributes, attributeNames, null);
        }

        @Override
        public boolean createUser(String username, String password, Map<String, String> attributes) {
            if (this.getSecurityManager().authoriseUserOperation(Operation.CREATE, username)) {
                return this.getPrincipalDatabase().createPrincipal(new UsernamePrincipal(username), password.toCharArray());
            }
            throw new AccessControlException("Do not have permission to create new user");
        }

        @Override
        public void deleteUser(String username) throws AccountNotFoundException {
            if (!this.getSecurityManager().authoriseUserOperation(Operation.DELETE, username)) {
                throw new AccessControlException("Cannot delete user " + username);
            }
            this.getPrincipalDatabase().deletePrincipal(new UsernamePrincipal(username));
        }

        private SecurityManager getSecurityManager() {
            return this._broker.getSecurityManager();
        }

        private PrincipalDatabase getPrincipalDatabase() {
            return ((PrincipalDatabaseAuthenticationManager)this.getAuthManager()).getPrincipalDatabase();
        }

        @Override
        public void setPassword(String username, String password) throws AccountNotFoundException {
            if (!this.getSecurityManager().authoriseUserOperation(Operation.UPDATE, username)) {
                throw new AccessControlException("Do not have permission to set password");
            }
            this.getPrincipalDatabase().updatePassword(new UsernamePrincipal(username), password.toCharArray());
        }

        @Override
        public Map<String, Map<String, String>> getUsers() {
            HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
            for (Principal principal : this.getPrincipalDatabase().getUsers()) {
                users.put(principal.getName(), Collections.emptyMap());
            }
            return users;
        }

        @Override
        public void reload() throws IOException {
            this.getPrincipalDatabase().reload();
        }

        @Override
        public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
            if (childClass == User.class) {
                String username = (String)attributes.get("name");
                String password = (String)attributes.get("password");
                UsernamePrincipal p = new UsernamePrincipal(username);
                if (this.createUser(username, password, null)) {
                    PrincipalAdapter pricipalAdapter = new PrincipalAdapter(p, this.getTaskExecutor());
                    return (C)pricipalAdapter;
                }
                throw new RuntimeException("Failed to create user");
            }
            return super.addChild(childClass, attributes, otherParents);
        }

        @Override
        public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
            if (clazz == User.class) {
                List<Principal> users = this.getPrincipalDatabase().getUsers();
                ArrayList<PrincipalAdapter> principals = new ArrayList<PrincipalAdapter>(users.size());
                for (Principal user : users) {
                    principals.add(new PrincipalAdapter(user, this.getTaskExecutor()));
                }
                Collection unmodifiablePrincipals = Collections.unmodifiableCollection(principals);
                return unmodifiablePrincipals;
            }
            return super.getChildren(clazz);
        }

        @Override
        protected void childAdded(ConfiguredObject child) {
        }

        @Override
        protected void childRemoved(ConfiguredObject child) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PrincipalAdapter
        extends AbstractAdapter
        implements User {
            private final Principal _user;

            public PrincipalAdapter(Principal user, TaskExecutor taskExecutor) {
                super(UUIDGenerator.generateUserUUID(PrincipalDatabaseAuthenticationManagerAdapter.this.getName(), user.getName()), taskExecutor);
                this._user = user;
            }

            @Override
            public void setPassword(String password) {
                try {
                    PrincipalDatabaseAuthenticationManagerAdapter.this.setPassword(this._user.getName(), password);
                }
                catch (AccountNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public String getName() {
                return this._user.getName();
            }

            @Override
            public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
                throw new IllegalStateException("Names cannot be updated");
            }

            @Override
            public State getActualState() {
                return State.ACTIVE;
            }

            @Override
            public boolean isDurable() {
                return true;
            }

            @Override
            public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("Durability cannot be updated");
            }

            @Override
            public LifetimePolicy getLifetimePolicy() {
                return LifetimePolicy.PERMANENT;
            }

            @Override
            public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("LifetimePolicy cannot be updated");
            }

            @Override
            public long getTimeToLive() {
                return 0L;
            }

            @Override
            public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new IllegalStateException("ttl cannot be updated");
            }

            @Override
            public Statistics getStatistics() {
                return NoStatistics.getInstance();
            }

            @Override
            public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
                return null;
            }

            @Override
            public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
                return null;
            }

            @Override
            public Collection<String> getAttributeNames() {
                return User.AVAILABLE_ATTRIBUTES;
            }

            @Override
            public Object getAttribute(String name) {
                if ("id".equals(name)) {
                    return this.getId();
                }
                if ("password".equals(name)) {
                    return null;
                }
                if ("name".equals(name)) {
                    return this.getName();
                }
                return super.getAttribute(name);
            }

            @Override
            public boolean changeAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                if (name.equals("password")) {
                    this.setPassword((String)desired);
                    return true;
                }
                return super.changeAttribute(name, expected, desired);
            }

            @Override
            protected boolean setState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
                if (desiredState == State.DELETED) {
                    try {
                        PrincipalDatabaseAuthenticationManagerAdapter.this.deleteUser(this._user.getName());
                    }
                    catch (AccountNotFoundException e) {
                        LOGGER.warn((Object)("Failed to delete user " + this._user), (Throwable)e);
                    }
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleAuthenticationProviderAdapter
    extends AuthenticationProviderAdapter<AuthenticationManager> {
        public SimpleAuthenticationProviderAdapter(UUID id, Broker broker, AuthenticationManager authManager, Map<String, Object> attributes, Collection<String> attributeNames) {
            super(id, broker, authManager, attributes, attributeNames, null);
        }

        @Override
        public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
            throw new UnsupportedOperationException();
        }
    }
}

