/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.adapter.AuthenticationProviderAdapter;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationProviderFactory {
    private final Iterable<AuthenticationManagerFactory> _factories;
    private Collection<String> _supportedAuthenticationProviders;

    public AuthenticationProviderFactory(QpidServiceLoader<AuthenticationManagerFactory> authManagerFactoryServiceLoader) {
        this._factories = authManagerFactoryServiceLoader.atLeastOneInstanceOf(AuthenticationManagerFactory.class);
        ArrayList<String> supportedAuthenticationProviders = new ArrayList<String>();
        for (AuthenticationManagerFactory factory : this._factories) {
            supportedAuthenticationProviders.add(factory.getType());
        }
        this._supportedAuthenticationProviders = Collections.unmodifiableCollection(supportedAuthenticationProviders);
    }

    public AuthenticationProvider create(UUID id, Broker broker, Map<String, Object> attributes) {
        AuthenticationProviderAdapter<?> provider = this.createAuthenticationProvider(id, broker, attributes);
        provider.getAuthManager().onCreate();
        return provider;
    }

    public AuthenticationProvider recover(UUID id, Map<String, Object> attributes, Broker broker) {
        return this.createAuthenticationProvider(id, broker, attributes);
    }

    private AuthenticationProviderAdapter<?> createAuthenticationProvider(UUID id, Broker broker, Map<String, Object> attributes) {
        for (AuthenticationManagerFactory factory : this._factories) {
            AuthenticationManager manager = factory.createInstance(attributes);
            if (manager == null) continue;
            AuthenticationProviderAdapter authenticationProvider = manager instanceof PrincipalDatabaseAuthenticationManager ? new AuthenticationProviderAdapter.PrincipalDatabaseAuthenticationManagerAdapter(id, broker, (PrincipalDatabaseAuthenticationManager)manager, attributes, factory.getAttributeNames()) : new AuthenticationProviderAdapter.SimpleAuthenticationProviderAdapter(id, broker, manager, attributes, factory.getAttributeNames());
            return authenticationProvider;
        }
        throw new IllegalArgumentException("No authentication provider factory found for configuration attributes " + attributes);
    }

    public Collection<String> getSupportedAuthenticationProviders() {
        return this._supportedAuthenticationProviders;
    }
}

