/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.adapter.GroupProviderAdapter;
import org.apache.qpid.server.plugin.GroupManagerFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.group.GroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupProviderFactory {
    private final Map<String, GroupManagerFactory> _factories;
    private Collection<String> _supportedGroupProviders;

    public GroupProviderFactory(QpidServiceLoader<GroupManagerFactory> groupManagerFactoryServiceLoader) {
        Iterable<GroupManagerFactory> factories = groupManagerFactoryServiceLoader.instancesOf(GroupManagerFactory.class);
        HashMap<String, GroupManagerFactory> registeredGroupProviderFactories = new HashMap<String, GroupManagerFactory>();
        for (GroupManagerFactory factory : factories) {
            GroupManagerFactory existingFactory = registeredGroupProviderFactories.put(factory.getType(), factory);
            if (existingFactory == null) continue;
            throw new IllegalConfigurationException("Group provider factory of the same type '" + factory.getType() + "' is already registered using class '" + existingFactory.getClass().getName() + "', can not register class '" + factory.getClass().getName() + "'");
        }
        this._factories = registeredGroupProviderFactories;
        this._supportedGroupProviders = Collections.unmodifiableCollection(registeredGroupProviderFactories.keySet());
    }

    public GroupProvider create(UUID id, Broker broker, Map<String, Object> attributes) {
        GroupProviderAdapter authenticationProvider = this.createGroupProvider(id, broker, attributes);
        authenticationProvider.getGroupManager().onCreate();
        return authenticationProvider;
    }

    public GroupProvider recover(UUID id, Broker broker, Map<String, Object> attributes) {
        return this.createGroupProvider(id, broker, attributes);
    }

    public Collection<String> getSupportedGroupProviders() {
        return this._supportedGroupProviders;
    }

    private GroupProviderAdapter createGroupProvider(UUID id, Broker broker, Map<String, Object> attributes) {
        for (GroupManagerFactory factory : this._factories.values()) {
            GroupManager manager = factory.createInstance(attributes);
            if (manager == null) continue;
            this.verifyGroupManager(manager, broker);
            return new GroupProviderAdapter(id, broker, manager, attributes, factory.getAttributeNames());
        }
        throw new IllegalConfigurationException("No group provider factory found for configuration attributes " + attributes);
    }

    private void verifyGroupManager(GroupManager manager, Broker broker) {
        Collection<GroupProvider> groupProviders = broker.getGroupProviders();
        for (GroupProvider groupProvider : groupProviders) {
            GroupManager providerManager;
            if (!(groupProvider instanceof GroupProviderAdapter) || !manager.equals(providerManager = ((GroupProviderAdapter)groupProvider).getGroupManager())) continue;
            throw new IllegalConfigurationException("A group provider with the same settings already exists");
        }
    }
}

