/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.adapter.AmqpPortAdapter;
import org.apache.qpid.server.model.adapter.PortAdapter;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortFactory {
    public static final int DEFAULT_AMQP_SEND_BUFFER_SIZE = 262144;
    public static final int DEFAULT_AMQP_RECEIVE_BUFFER_SIZE = 262144;
    public static final boolean DEFAULT_AMQP_NEED_CLIENT_AUTH = false;
    public static final boolean DEFAULT_AMQP_WANT_CLIENT_AUTH = false;
    public static final boolean DEFAULT_AMQP_TCP_NO_DELAY = true;
    public static final String DEFAULT_AMQP_BINDING = "*";
    public static final Transport DEFAULT_TRANSPORT = Transport.TCP;
    private final Collection<Protocol> _defaultProtocols;

    public PortFactory() {
        String includedProtocols;
        EnumSet<Protocol> defaultProtocols = EnumSet.of(Protocol.AMQP_0_8, Protocol.AMQP_0_9, Protocol.AMQP_0_9_1, Protocol.AMQP_0_10, Protocol.AMQP_1_0);
        String excludedProtocols = System.getProperty("qpid.broker_default_amqp_protocol_excludes");
        if (excludedProtocols != null) {
            String[] excludes;
            for (String exclude : excludes = excludedProtocols.split(",")) {
                Protocol protocol = Protocol.valueOf(exclude);
                defaultProtocols.remove((Object)protocol);
            }
        }
        if ((includedProtocols = System.getProperty("qpid.broker_default_amqp_protocol_includes")) != null) {
            String[] includes;
            for (String include : includes = includedProtocols.split(",")) {
                Protocol protocol = Protocol.valueOf(include);
                defaultProtocols.add(protocol);
            }
        }
        this._defaultProtocols = Collections.unmodifiableCollection(defaultProtocols);
    }

    public Port createPort(UUID id, Broker broker, Map<String, Object> attributes) {
        PortAdapter port;
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("transports", Collections.singleton(DEFAULT_TRANSPORT));
        Object portValue = attributes.get("port");
        if (portValue == null) {
            throw new IllegalConfigurationException("Port attribute is not specified for port: " + attributes);
        }
        Set<Protocol> protocols = MapValueConverter.getEnumSetAttribute("protocols", attributes, Protocol.class);
        if (this.isAmqpProtocol(protocols, attributes)) {
            boolean useClientAuth;
            Object binding = attributes.get("bindingAddress");
            if (binding == null) {
                binding = DEFAULT_AMQP_BINDING;
                defaults.put("bindingAddress", DEFAULT_AMQP_BINDING);
            }
            defaults.put("name", binding + ":" + portValue);
            defaults.put("protocols", this._defaultProtocols);
            defaults.put("tcpNoDelay", true);
            defaults.put("wantClientAuth", false);
            defaults.put("needClientAuth", false);
            defaults.put("receiveBufferSize", 262144);
            defaults.put("sendBufferSize", 262144);
            port = new AmqpPortAdapter(id, broker, attributes, defaults, broker.getTaskExecutor());
            boolean bl = useClientAuth = (Boolean)port.getAttribute("needClientAuth") != false || (Boolean)port.getAttribute("wantClientAuth") != false;
            if (useClientAuth && port.getTrustStores().isEmpty()) {
                throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust stores configured.");
            }
            if (useClientAuth && !port.getTransports().contains((Object)Transport.SSL)) {
                throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
            }
        } else {
            if (protocols.size() > 1) {
                throw new IllegalConfigurationException("Only one protocol can be used on non AMQP port");
            }
            Protocol protocol = protocols.iterator().next();
            if (!broker.isManagementMode() && protocol.getProtocolType() != Protocol.ProtocolType.HTTP) {
                Collection<Port> existingPorts = broker.getPorts();
                for (Port existingPort : existingPorts) {
                    Collection<Protocol> portProtocols = existingPort.getProtocols();
                    if (portProtocols == null || !portProtocols.contains((Object)protocol)) continue;
                    throw new IllegalConfigurationException("Port for protocol " + (Object)((Object)protocol) + " already exists. Only one management port per protocol can be created.");
                }
            }
            defaults.put("name", portValue + "-" + protocol.name());
            port = new PortAdapter(id, broker, attributes, defaults, broker.getTaskExecutor());
            boolean rmiPort = port.getProtocols().contains((Object)Protocol.RMI);
            if (rmiPort && port.getTransports().contains((Object)Transport.SSL)) {
                throw new IllegalConfigurationException("Can't create RMI registry port which requires SSL");
            }
        }
        if (port.getTransports().contains((Object)Transport.SSL) && port.getKeyStore() == null) {
            throw new IllegalConfigurationException("Can't create port which requires SSL but has no key store configured.");
        }
        return port;
    }

    private boolean isAmqpProtocol(Set<Protocol> protocols, Map<String, Object> portAttributes) {
        if (protocols == null || protocols.isEmpty()) {
            return true;
        }
        HashSet<Protocol.ProtocolType> protocolTypes = new HashSet<Protocol.ProtocolType>();
        for (Protocol protocolObject : protocols) {
            protocolTypes.add(protocolObject.getProtocolType());
        }
        if (protocolTypes.size() > 1) {
            throw new IllegalConfigurationException("Found different protocol types '" + protocolTypes + "' for port configuration: " + portAttributes);
        }
        return protocolTypes.contains((Object)Protocol.ProtocolType.AMQP);
    }

    public Collection<Protocol> getDefaultProtocols() {
        return this._defaultProtocols;
    }
}

