/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.io.File;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.configuration.XmlConfigurationUtilities;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueType;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.ConnectionAdapter;
import org.apache.qpid.server.model.adapter.ExchangeAdapter;
import org.apache.qpid.server.model.adapter.QueueAdapter;
import org.apache.qpid.server.model.adapter.StatisticsAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAliasAdapter;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.plugin.VirtualHostFactory;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.DurableConfigurationStoreHelper;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.UnknownExchangeException;
import org.apache.qpid.server.virtualhost.VirtualHostListener;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualHostAdapter
extends AbstractAdapter
implements VirtualHost,
VirtualHostListener {
    private static final Logger LOGGER = Logger.getLogger(VirtualHostAdapter.class);
    public static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put("name", String.class);
            this.put("type", String.class);
            this.put("storePath", String.class);
            this.put("storeType", String.class);
            this.put("configPath", String.class);
            this.put("state", State.class);
        }
    });
    private org.apache.qpid.server.virtualhost.VirtualHost _virtualHost;
    private final Map<AMQConnectionModel, ConnectionAdapter> _connectionAdapters = new HashMap<AMQConnectionModel, ConnectionAdapter>();
    private final Map<AMQQueue, QueueAdapter> _queueAdapters = new HashMap<AMQQueue, QueueAdapter>();
    private final Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> _exchangeAdapters = new HashMap<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter>();
    private StatisticsAdapter _statistics;
    private final Broker _broker;
    private final List<VirtualHostAlias> _aliases = new ArrayList<VirtualHostAlias>();
    private StatisticsGatherer _brokerStatisticsGatherer;

    public VirtualHostAdapter(UUID id, Map<String, Object> attributes, Broker broker, StatisticsGatherer brokerStatisticsGatherer, TaskExecutor taskExecutor) {
        super(id, null, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES, false), taskExecutor, false);
        this._broker = broker;
        this._brokerStatisticsGatherer = brokerStatisticsGatherer;
        this.validateAttributes();
        this.addParent(Broker.class, broker);
    }

    private void validateAttributes() {
        String name = this.getName();
        if (name == null || "".equals(name.trim())) {
            throw new IllegalConfigurationException("Virtual host name must be specified");
        }
        String configurationFile = (String)this.getAttribute("configPath");
        String type = (String)this.getAttribute("type");
        boolean invalidAttributes = false;
        if (configurationFile == null) {
            if (type == null) {
                invalidAttributes = true;
            } else {
                this.validateAttributes(type);
            }
        }
        if (invalidAttributes) {
            throw new IllegalConfigurationException("Please specify either the 'configPath' attribute or 'type' attributes");
        }
        try {
            this.createVirtualHostConfiguration(name);
        }
        catch (ConfigurationException e) {
            throw new IllegalConfigurationException("Failed to validate configuration", e);
        }
    }

    private void validateAttributes(String type) {
        VirtualHostFactory factory = VirtualHostFactory.FACTORIES.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown virtual host type '" + type + "'.  Valid types are: " + VirtualHostFactory.TYPES.get());
        }
        factory.validateAttributes(this.getActualAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateExchanges() {
        Collection<org.apache.qpid.server.exchange.Exchange> actualExchanges = this._virtualHost.getExchanges();
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            for (org.apache.qpid.server.exchange.Exchange exchange : actualExchanges) {
                if (this._exchangeAdapters.containsKey(exchange)) continue;
                this._exchangeAdapters.put(exchange, new ExchangeAdapter(this, exchange));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateQueues() {
        Collection<AMQQueue> actualQueues = this._virtualHost.getQueueRegistry().getQueues();
        if (actualQueues != null) {
            Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
            synchronized (map) {
                for (AMQQueue queue : actualQueues) {
                    if (this._queueAdapters.containsKey(queue)) continue;
                    this._queueAdapters.put(queue, new QueueAdapter(this, queue));
                }
            }
        }
    }

    @Override
    public Collection<VirtualHostAlias> getAliases() {
        return Collections.unmodifiableCollection(this._aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Connection> getConnections() {
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            return new ArrayList<Connection>(this._connectionAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionAdapter getConnectionAdapter(AMQConnectionModel connection) {
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            return this._connectionAdapters.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Queue> getQueues() {
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            return new ArrayList<Queue>(this._queueAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Exchange> getExchanges() {
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            return new ArrayList<Exchange>(this._exchangeAdapters.values());
        }
    }

    public Exchange createExchange(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        attributes = new HashMap<String, Object>(attributes);
        String name = MapValueConverter.getStringAttribute("name", attributes, null);
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.ACTIVE);
        boolean durable = MapValueConverter.getBooleanAttribute("durable", attributes, false);
        LifetimePolicy lifetime = MapValueConverter.getEnumAttribute(LifetimePolicy.class, "lifetimePolicy", attributes, LifetimePolicy.PERMANENT);
        String type = MapValueConverter.getStringAttribute("type", attributes, null);
        long ttl = MapValueConverter.getLongAttribute("timeToLive", attributes, 0L);
        attributes.remove("name");
        attributes.remove("state");
        attributes.remove("durable");
        attributes.remove("lifetimePolicy");
        attributes.remove("type");
        attributes.remove("timeToLive");
        return this.createExchange(name, state, durable, lifetime, ttl, type, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange createExchange(String name, State initialState, boolean durable, LifetimePolicy lifetime, long ttl, String type, Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        this.checkVHostStateIsActive();
        try {
            String alternateExchange = null;
            if (attributes.containsKey("alternateExchange")) {
                Object altExchangeObject = attributes.get("alternateExchange");
                if (altExchangeObject instanceof Exchange) {
                    alternateExchange = ((Exchange)altExchangeObject).getName();
                } else if (altExchangeObject instanceof UUID) {
                    for (Exchange ex : this.getExchanges()) {
                        if (!altExchangeObject.equals(ex.getId())) continue;
                        alternateExchange = ex.getName();
                        break;
                    }
                } else if (altExchangeObject instanceof String) {
                    for (Exchange ex : this.getExchanges()) {
                        if (!altExchangeObject.equals(ex.getName())) continue;
                        alternateExchange = ex.getName();
                        break;
                    }
                    if (alternateExchange == null) {
                        try {
                            UUID id = UUID.fromString(altExchangeObject.toString());
                            for (Exchange ex : this.getExchanges()) {
                                if (!id.equals(ex.getId())) continue;
                                alternateExchange = ex.getName();
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
            }
            org.apache.qpid.server.exchange.Exchange exchange = this._virtualHost.createExchange(null, name, type, durable, lifetime == LifetimePolicy.AUTO_DELETE, alternateExchange);
            Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
            synchronized (map) {
                return this._exchangeAdapters.get(exchange);
            }
        }
        catch (ExchangeExistsException e) {
            throw new IllegalArgumentException("Exchange with name '" + name + "' already exists");
        }
        catch (ReservedExchangeNameException e) {
            throw new UnsupportedOperationException("'" + name + "' is a reserved exchange name");
        }
        catch (UnknownExchangeException e) {
            throw new IllegalArgumentException("Alternate Exchange with name '" + e.getExchangeName() + "' does not exist");
        }
        catch (AMQException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Queue createQueue(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        if ((attributes = new HashMap<String, Object>(attributes)).containsKey("type")) {
            String typeAttribute = MapValueConverter.getStringAttribute("type", attributes, null);
            QueueType queueType = null;
            try {
                queueType = QueueType.valueOf(typeAttribute.toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported queue type :" + typeAttribute);
            }
            if (queueType == QueueType.LVQ && attributes.get("lvqKey") == null) {
                attributes.put("lvqKey", "qpid.LVQ_key");
            } else if (queueType == QueueType.PRIORITY && attributes.get("priorities") == null) {
                attributes.put("priorities", 10);
            } else if (queueType == QueueType.SORTED && attributes.get("sortKey") == null) {
                throw new IllegalArgumentException("Sort key is not specified for sorted queue");
            }
        }
        if (attributes.containsKey("messageGroupKey")) {
            String key = MapValueConverter.getStringAttribute("messageGroupKey", attributes);
            attributes.remove("messageGroupKey");
            attributes.put("qpid.group_header_key", key);
        }
        if (attributes.containsKey("messageGroupSharedGroups") && MapValueConverter.getBooleanAttribute("messageGroupSharedGroups", attributes)) {
            attributes.remove("messageGroupSharedGroups");
            attributes.put("qpid.shared_msg_group", "1");
        }
        String name = MapValueConverter.getStringAttribute("name", attributes, null);
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.ACTIVE);
        boolean durable = MapValueConverter.getBooleanAttribute("durable", attributes, false);
        LifetimePolicy lifetime = MapValueConverter.getEnumAttribute(LifetimePolicy.class, "lifetimePolicy", attributes, LifetimePolicy.PERMANENT);
        long ttl = MapValueConverter.getLongAttribute("timeToLive", attributes, 0L);
        boolean exclusive = MapValueConverter.getBooleanAttribute("exclusive", attributes, false);
        attributes.remove("name");
        attributes.remove("state");
        attributes.remove("durable");
        attributes.remove("lifetimePolicy");
        attributes.remove("timeToLive");
        ArrayList<String> attrNames = new ArrayList<String>(attributes.keySet());
        for (String attr : attrNames) {
            if (!QueueAdapter.ATTRIBUTE_MAPPINGS.containsKey(attr)) continue;
            attributes.put(QueueAdapter.ATTRIBUTE_MAPPINGS.get(attr), attributes.remove(attr));
        }
        return this.createQueue(name, state, durable, exclusive, lifetime, ttl, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue createQueue(String name, State initialState, boolean durable, boolean exclusive, LifetimePolicy lifetime, long ttl, Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        AuthenticatedPrincipal authenticatedPrincipal;
        this.checkVHostStateIsActive();
        String owner = null;
        if (exclusive && (authenticatedPrincipal = AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject(SecurityManager.getThreadSubject())) != null) {
            owner = authenticatedPrincipal.getName();
        }
        try {
            QueueRegistry queueRegistry;
            QueueRegistry queueRegistry2 = queueRegistry = this._virtualHost.getQueueRegistry();
            synchronized (queueRegistry2) {
                if (this._virtualHost.getQueueRegistry().getQueue(name) != null) {
                    throw new IllegalArgumentException("Queue with name " + name + " already exists");
                }
                AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(name, this._virtualHost.getName()), name, durable, owner, lifetime == LifetimePolicy.AUTO_DELETE, exclusive, this._virtualHost, attributes);
                if (durable) {
                    DurableConfigurationStoreHelper.createQueue(this._virtualHost.getDurableConfigurationStore(), queue, FieldTable.convertToFieldTable(attributes));
                }
                Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
                synchronized (map) {
                    return this._queueAdapters.get(queue);
                }
            }
        }
        catch (AMQException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public String getType() {
        return (String)this.getAttribute("type");
    }

    public String setType(String currentType, String desiredType) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        if (this._virtualHost == null) {
            State state = (State)((Object)super.getAttribute("state"));
            if (state == null) {
                return State.INITIALISING;
            }
            return state;
        }
        org.apache.qpid.server.virtualhost.State implementationState = this._virtualHost.getState();
        switch (implementationState) {
            case INITIALISING: {
                return State.INITIALISING;
            }
            case ACTIVE: {
                return State.ACTIVE;
            }
            case PASSIVE: {
                return State.REPLICA;
            }
            case STOPPED: {
                return State.STOPPED;
            }
            case ERRORED: {
                return State.ERRORED;
            }
        }
        throw new IllegalStateException("Unsupported state:" + (Object)((Object)implementationState));
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Exchange.class) {
            return this.getExchanges();
        }
        if (clazz == Queue.class) {
            return this.getQueues();
        }
        if (clazz == Connection.class) {
            return this.getConnections();
        }
        if (clazz == VirtualHostAlias.class) {
            return this.getAliases();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Exchange.class) {
            this.createExchange(attributes);
            return null;
        }
        if (childClass == Queue.class) {
            this.createQueue(attributes);
            return null;
        }
        if (childClass == VirtualHostAlias.class) {
            throw new UnsupportedOperationException();
        }
        if (childClass == Connection.class) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exchangeRegistered(org.apache.qpid.server.exchange.Exchange exchange) {
        ExchangeAdapter adapter = null;
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            if (!this._exchangeAdapters.containsKey(exchange)) {
                adapter = new ExchangeAdapter(this, exchange);
                this._exchangeAdapters.put(exchange, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exchangeUnregistered(org.apache.qpid.server.exchange.Exchange exchange) {
        ExchangeAdapter adapter;
        Map<org.apache.qpid.server.exchange.Exchange, ExchangeAdapter> map = this._exchangeAdapters;
        synchronized (map) {
            adapter = this._exchangeAdapters.remove(exchange);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueRegistered(AMQQueue queue) {
        QueueAdapter adapter = null;
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            if (!this._queueAdapters.containsKey(queue)) {
                adapter = new QueueAdapter(this, queue);
                this._queueAdapters.put(queue, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueUnregistered(AMQQueue queue) {
        QueueAdapter adapter;
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            adapter = this._queueAdapters.remove(queue);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionRegistered(AMQConnectionModel connection) {
        ConnectionAdapter adapter = null;
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            if (!this._connectionAdapters.containsKey(connection)) {
                adapter = new ConnectionAdapter(connection, this.getTaskExecutor());
                this._connectionAdapters.put(connection, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionUnregistered(AMQConnectionModel connection) {
        ConnectionAdapter adapter;
        Map<AMQConnectionModel, ConnectionAdapter> map = this._connectionAdapters;
        synchronized (map) {
            adapter = this._connectionAdapters.remove(connection);
        }
        if (adapter != null) {
            adapter.getSessions();
            this.childRemoved(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueAdapter getQueueAdapter(AMQQueue queue) {
        Map<AMQQueue, QueueAdapter> map = this._queueAdapters;
        synchronized (map) {
            return this._queueAdapters.get(queue);
        }
    }

    @Override
    public Collection<String> getExchangeTypes() {
        Collection<ExchangeType<? extends org.apache.qpid.server.exchange.Exchange>> types = this._virtualHost.getExchangeTypes();
        ArrayList<String> exchangeTypes = new ArrayList<String>();
        for (ExchangeType<? extends org.apache.qpid.server.exchange.Exchange> type : types) {
            exchangeTypes.add(type.getName().asString());
        }
        return Collections.unmodifiableCollection(exchangeTypes);
    }

    @Override
    public void executeTransaction(VirtualHost.TransactionalOperation op) {
        MessageStore store = this._virtualHost.getMessageStore();
        final LocalTransaction txn = new LocalTransaction(store);
        op.withinTransaction(new VirtualHost.Transaction(){

            public void dequeue(final QueueEntry entry) {
                if (entry.acquire()) {
                    txn.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }

            public void copy(QueueEntry entry, Queue queue) {
                final ServerMessage message = entry.getMessage();
                final AMQQueue toQueue = ((QueueAdapter)queue).getAMQQueue();
                txn.enqueue(toQueue, (EnqueableMessage)message, new ServerTransaction.Action(){

                    public void postCommit() {
                        try {
                            toQueue.enqueue(message);
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void onRollback() {
                    }
                });
            }

            public void move(final QueueEntry entry, Queue queue) {
                final ServerMessage message = entry.getMessage();
                final AMQQueue toQueue = ((QueueAdapter)queue).getAMQQueue();
                if (entry.acquire()) {
                    txn.enqueue(toQueue, (EnqueableMessage)message, new ServerTransaction.Action(){

                        public void postCommit() {
                            try {
                                toQueue.enqueue(message);
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void onRollback() {
                            entry.release();
                        }
                    });
                    txn.dequeue(entry.getQueue(), message, new ServerTransaction.Action(){

                        public void postCommit() {
                            entry.discard();
                        }

                        public void onRollback() {
                        }
                    });
                }
            }
        });
        txn.commit();
    }

    org.apache.qpid.server.virtualhost.VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("state".equals(name)) {
            return this.getActualState();
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return LifetimePolicy.PERMANENT;
        }
        if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name) || this._virtualHost == null)) {
            return this.getAttributeFromVirtualHostImplementation(name);
        }
        return super.getAttribute(name);
    }

    private Object getAttributeFromVirtualHostImplementation(String name) {
        if ("supportedExchangeTypes".equals(name)) {
            ArrayList<String> types = new ArrayList<String>();
            for (ExchangeType<? extends org.apache.qpid.server.exchange.Exchange> type : this._virtualHost.getExchangeTypes()) {
                types.add(type.getName().asString());
            }
            return Collections.unmodifiableCollection(types);
        }
        if (!"supportedQueueTypes".equals(name)) {
            if ("queue.deadLetterQueueEnabled".equals(name)) {
                return this._virtualHost.getConfiguration().isDeadLetterQueueEnabled();
            }
            if ("housekeepingCheckPeriod".equals(name)) {
                return this._virtualHost.getConfiguration().getHousekeepingCheckPeriod();
            }
            if ("queue.maximumDeliveryAttempts".equals(name)) {
                return this._virtualHost.getConfiguration().getMaxDeliveryCount();
            }
            if ("queue.flowControlSizeBytes".equals(name)) {
                return this._virtualHost.getConfiguration().getCapacity();
            }
            if ("queue.flowResumeSizeBytes".equals(name)) {
                return this._virtualHost.getConfiguration().getFlowResumeCapacity();
            }
            if ("storeType".equals(name)) {
                return this._virtualHost.getMessageStore().getStoreType();
            }
            if ("storePath".equals(name)) {
                return this._virtualHost.getMessageStore().getStoreLocation();
            }
            if ("storeTransactionIdleTimeoutClose".equals(name)) {
                return this._virtualHost.getConfiguration().getTransactionTimeoutIdleClose();
            }
            if ("storeTransactionIdleTimeoutWarn".equals(name)) {
                return this._virtualHost.getConfiguration().getTransactionTimeoutIdleWarn();
            }
            if ("storeTransactionOpenTimeoutClose".equals(name)) {
                return this._virtualHost.getConfiguration().getTransactionTimeoutOpenClose();
            }
            if ("storeTransactionOpenTimeoutWarn".equals(name)) {
                return this._virtualHost.getConfiguration().getTransactionTimeoutOpenWarn();
            }
            if ("queue.alertRepeatGap".equals(name)) {
                return this._virtualHost.getConfiguration().getMinimumAlertRepeatGap();
            }
            if ("queue.alertThresholdMessageAge".equals(name)) {
                return this._virtualHost.getConfiguration().getMaximumMessageAge();
            }
            if ("queue.alertThresholdMessageSize".equals(name)) {
                return this._virtualHost.getConfiguration().getMaximumMessageSize();
            }
            if ("queue.alertThresholdQueueDepthBytes".equals(name)) {
                return this._virtualHost.getConfiguration().getMaximumQueueDepth();
            }
            if ("queue.alertThresholdQueueDepthMessages".equals(name)) {
                return this._virtualHost.getConfiguration().getMaximumMessageCount();
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    private void checkVHostStateIsActive() {
        if (!org.apache.qpid.server.virtualhost.State.ACTIVE.equals((Object)this._virtualHost.getState())) {
            throw new IllegalStateException("The virtual hosts state of " + (Object)((Object)this._virtualHost.getState()) + " does not permit this operation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.ACTIVE) {
            try {
                this.activate();
            }
            catch (RuntimeException e) {
                this.changeAttribute("state", (Object)State.INITIALISING, (Object)State.ERRORED);
                if (this._broker.isManagementMode()) {
                    LOGGER.warn((Object)("Failed to activate virtual host: " + this.getName()), (Throwable)e);
                }
                throw e;
            }
            return true;
        }
        if (desiredState == State.STOPPED) {
            if (this._virtualHost != null) {
                try {
                    this._virtualHost.close();
                }
                finally {
                    this._broker.getVirtualHostRegistry().unregisterVirtualHost(this._virtualHost);
                }
            }
            return true;
        }
        if (desiredState == State.DELETED) {
            String hostName = this.getName();
            if (hostName.equals(this._broker.getAttribute("defaultVirtualHost"))) {
                throw new IntegrityViolationException("Cannot delete default virtual host '" + hostName + "'");
            }
            if (this._virtualHost != null) {
                MessageStore ms;
                if (this._virtualHost.getState() == org.apache.qpid.server.virtualhost.State.ACTIVE) {
                    this.setDesiredState(currentState, State.STOPPED);
                }
                if ((ms = this._virtualHost.getMessageStore()) != null) {
                    try {
                        ms.onDelete();
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Exception occured on store deletion", (Throwable)e);
                    }
                }
                this._virtualHost = null;
            }
            this.setAttribute("state", (Object)this.getActualState(), (Object)State.DELETED);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        VirtualHostRegistry virtualHostRegistry = this._broker.getVirtualHostRegistry();
        String virtualHostName = this.getName();
        try {
            VirtualHostConfiguration configuration = this.createVirtualHostConfiguration(virtualHostName);
            String type = configuration.getType();
            VirtualHostFactory factory = VirtualHostFactory.FACTORIES.get(type);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown virtual host type: " + type);
            }
            this._virtualHost = factory.createVirtualHost(this._broker.getVirtualHostRegistry(), this._brokerStatisticsGatherer, this._broker.getSecurityManager(), configuration, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create virtual host " + virtualHostName, e);
        }
        virtualHostRegistry.registerVirtualHost(this._virtualHost);
        this._statistics = new VirtualHostStatisticsAdapter(this._virtualHost);
        this._virtualHost.addVirtualHostListener(this);
        this.populateQueues();
        this.populateExchanges();
        List<VirtualHostAlias> list = this._aliases;
        synchronized (list) {
            for (Port port : this._broker.getPorts()) {
                if (!Protocol.hasAmqpProtocol(port.getProtocols())) continue;
                this._aliases.add(new VirtualHostAliasAdapter(this, port));
            }
        }
    }

    private VirtualHostConfiguration createVirtualHostConfiguration(String virtualHostName) throws ConfigurationException {
        VirtualHostConfiguration configuration;
        String configurationFile = (String)this.getAttribute("configPath");
        if (configurationFile == null) {
            XmlConfigurationUtilities.MyConfiguration basicConfiguration = new XmlConfigurationUtilities.MyConfiguration();
            PropertiesConfiguration config = new PropertiesConfiguration();
            String type = (String)this.getAttribute("type");
            config.addProperty("type", (Object)type);
            VirtualHostFactory factory = VirtualHostFactory.FACTORIES.get(type);
            if (factory != null) {
                for (Map.Entry<String, Object> entry : factory.createVirtualHostConfiguration(this).entrySet()) {
                    config.addProperty(entry.getKey(), entry.getValue());
                }
            }
            basicConfiguration.addConfiguration((Configuration)config);
            CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.addConfiguration((Configuration)new SystemConfiguration());
            compositeConfiguration.addConfiguration((Configuration)basicConfiguration);
            configuration = new VirtualHostConfiguration(virtualHostName, (Configuration)compositeConfiguration, this._broker);
        } else {
            if (!new File(configurationFile).exists()) {
                throw new IllegalConfigurationException("Configuration file '" + configurationFile + "' does not exist");
            }
            configuration = new VirtualHostConfiguration(virtualHostName, new File(configurationFile), this._broker);
            String type = configuration.getType();
            this.changeAttribute("type", null, type);
            VirtualHostFactory factory = VirtualHostFactory.FACTORIES.get(type);
            if (factory != null) {
                for (Map.Entry<String, Object> entry : factory.convertVirtualHostConfiguration(configuration.getConfig()).entrySet()) {
                    this.changeAttribute(entry.getKey(), this.getAttribute(entry.getKey()), entry.getValue());
                }
            }
        }
        return configuration;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this._virtualHost.getSecurityManager();
    }

    @Override
    public MessageStore getMessageStore() {
        return this._virtualHost.getMessageStore();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        throw new UnsupportedOperationException("Changing attributes on virtualhosts is not supported.");
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), VirtualHost.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of virtual host is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), VirtualHost.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of virtual host attributes is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), VirtualHost.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of virtual host attributes is denied");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VirtualHostStatisticsAdapter
    extends StatisticsAdapter {
        private final org.apache.qpid.server.virtualhost.VirtualHost _vhost;
        private static final Collection<String> VHOST_STATS = Arrays.asList("queueCount", "exchangeCount", "connectionCount");

        public VirtualHostStatisticsAdapter(org.apache.qpid.server.virtualhost.VirtualHost virtualHost) {
            super(virtualHost);
            this._vhost = virtualHost;
        }

        @Override
        public Collection<String> getStatisticNames() {
            HashSet<String> stats = new HashSet<String>(super.getStatisticNames());
            stats.addAll(VHOST_STATS);
            return stats;
        }

        @Override
        public Object getStatistic(String name) {
            if ("queueCount".equals(name)) {
                return this._vhost.getQueueRegistry().getQueues().size();
            }
            if ("exchangeCount".equals(name)) {
                return this._vhost.getExchanges().size();
            }
            if ("connectionCount".equals(name)) {
                return this._vhost.getConnectionRegistry().getConnections().size();
            }
            return super.getStatistic(name);
        }
    }
}

