/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;

public interface JDBCConnectionProviderFactory
extends Pluggable {
    public String getType();

    public ConnectionProvider getConnectionProvider(String var1, VirtualHost var2) throws SQLException;

    public static final class FACTORIES {
        private FACTORIES() {
        }

        public static JDBCConnectionProviderFactory get(String type) {
            QpidServiceLoader<JDBCConnectionProviderFactory> qpidServiceLoader = new QpidServiceLoader<JDBCConnectionProviderFactory>();
            Iterable<JDBCConnectionProviderFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(JDBCConnectionProviderFactory.class);
            for (JDBCConnectionProviderFactory factory : factories) {
                if (!factory.getType().equals(type)) continue;
                return factory;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TYPES {
        private TYPES() {
        }

        public static Collection<String> get() {
            QpidServiceLoader<JDBCConnectionProviderFactory> qpidServiceLoader = new QpidServiceLoader<JDBCConnectionProviderFactory>();
            Iterable<JDBCConnectionProviderFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(JDBCConnectionProviderFactory.class);
            ArrayList<String> names = new ArrayList<String>();
            for (JDBCConnectionProviderFactory factory : factories) {
                names.add(factory.getType());
            }
            return Collections.unmodifiableCollection(names);
        }
    }
}

