/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.apache.qpid.server.plugin.Pluggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QpidServiceLoader<C extends Pluggable> {
    private static final Logger _logger = Logger.getLogger(QpidServiceLoader.class);

    public Iterable<C> instancesOf(Class<C> clazz) {
        return this.instancesOf(clazz, false);
    }

    public Iterable<C> atLeastOneInstanceOf(Class<C> clazz) {
        return this.instancesOf(clazz, true);
    }

    private Iterable<C> instancesOf(Class<C> clazz, boolean atLeastOne) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator<C> serviceLoaderIterator = ServiceLoader.load(clazz, classLoader).iterator();
        ArrayList<C> serviceImplementations = new ArrayList<C>();
        while (serviceLoaderIterator.hasNext()) {
            serviceImplementations.add(serviceLoaderIterator.next());
        }
        if (atLeastOne && serviceImplementations.isEmpty()) {
            throw new RuntimeException("At least one implementation of " + clazz + " expected");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Found " + serviceImplementations.size() + " implementations of " + clazz));
        }
        return serviceImplementations;
    }
}

