/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VirtualHostFactory
extends Pluggable {
    @Override
    public String getType();

    public org.apache.qpid.server.virtualhost.VirtualHost createVirtualHost(VirtualHostRegistry var1, StatisticsGatherer var2, SecurityManager var3, VirtualHostConfiguration var4, VirtualHost var5) throws Exception;

    public void validateAttributes(Map<String, Object> var1);

    public Map<String, Object> createVirtualHostConfiguration(VirtualHostAdapter var1);

    public Map<String, Object> convertVirtualHostConfiguration(Configuration var1);

    public static final class FACTORIES {
        private FACTORIES() {
        }

        public static VirtualHostFactory get(String type) {
            QpidServiceLoader<VirtualHostFactory> qpidServiceLoader = new QpidServiceLoader<VirtualHostFactory>();
            Iterable<VirtualHostFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(VirtualHostFactory.class);
            for (VirtualHostFactory factory : factories) {
                if (!factory.getType().equals(type)) continue;
                return factory;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TYPES {
        private TYPES() {
        }

        public static Collection<String> get() {
            QpidServiceLoader<VirtualHostFactory> qpidServiceLoader = new QpidServiceLoader<VirtualHostFactory>();
            Iterable<VirtualHostFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(VirtualHostFactory.class);
            ArrayList<String> names = new ArrayList<String>();
            for (VirtualHostFactory factory : factories) {
                names.add(factory.getType());
            }
            return Collections.unmodifiableCollection(names);
        }
    }
}

