/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.LinkModel;

public class LinkRegistry {
    private final Map<String, LinkModel> _sendingLinks = new HashMap<String, LinkModel>();
    private final Map<String, LinkModel> _receivingLinks = new HashMap<String, LinkModel>();

    public synchronized LinkModel getDurableSendingLink(String name) {
        return this._sendingLinks.get(name);
    }

    public synchronized boolean registerSendingLink(String name, LinkModel link) {
        if (this._sendingLinks.containsKey(name)) {
            return false;
        }
        this._sendingLinks.put(name, link);
        return true;
    }

    public synchronized boolean unregisterSendingLink(String name) {
        if (!this._sendingLinks.containsKey(name)) {
            return false;
        }
        this._sendingLinks.remove(name);
        return true;
    }

    public synchronized LinkModel getDurableReceivingLink(String name) {
        return this._receivingLinks.get(name);
    }

    public synchronized boolean registerReceivingLink(String name, LinkModel link) {
        if (this._receivingLinks.containsKey(name)) {
            return false;
        }
        this._receivingLinks.put(name, link);
        return true;
    }
}

