/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.log4j.Logger;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.security.SSLStatus;
import org.apache.qpid.transport.network.security.ssl.SSLBufferingSender;
import org.apache.qpid.transport.network.security.ssl.SSLReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngine
implements ServerProtocolEngine {
    private static final Logger _logger = Logger.getLogger(MultiVersionProtocolEngine.class);
    private final long _id;
    private final SSLContext _sslContext;
    private final boolean _wantClientAuth;
    private final boolean _needClientAuth;
    private final Port _port;
    private final Transport _transport;
    private final ProtocolEngineCreator[] _creators;
    private Set<AmqpProtocolVersion> _supported;
    private String _fqdn;
    private final Broker _broker;
    private NetworkConnection _network;
    private Sender<ByteBuffer> _sender;
    private final AmqpProtocolVersion _defaultSupportedReply;
    private volatile ServerProtocolEngine _delegate = new SelfDelegateProtocolEngine();
    private static final int MINIMUM_REQUIRED_HEADER_BYTES = 8;

    public MultiVersionProtocolEngine(Broker broker, SSLContext sslContext, boolean wantClientAuth, boolean needClientAuth, Set<AmqpProtocolVersion> supported, AmqpProtocolVersion defaultSupportedReply, Port port, Transport transport, long id, ProtocolEngineCreator[] creators) {
        if (defaultSupportedReply != null && !supported.contains((Object)defaultSupportedReply)) {
            throw new IllegalArgumentException("The configured default reply (" + (Object)((Object)defaultSupportedReply) + ") to an unsupported protocol version initiation is itself not supported!");
        }
        this._id = id;
        this._broker = broker;
        this._supported = supported;
        this._defaultSupportedReply = defaultSupportedReply;
        this._sslContext = sslContext;
        this._wantClientAuth = wantClientAuth;
        this._needClientAuth = needClientAuth;
        this._port = port;
        this._transport = transport;
        this._creators = creators;
    }

    public SocketAddress getRemoteAddress() {
        return this._delegate.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._delegate.getLocalAddress();
    }

    public long getWrittenBytes() {
        return this._delegate.getWrittenBytes();
    }

    public long getReadBytes() {
        return this._delegate.getReadBytes();
    }

    public void closed() {
        this._delegate.closed();
    }

    public void writerIdle() {
        this._delegate.writerIdle();
    }

    public void readerIdle() {
        this._delegate.readerIdle();
    }

    public void received(ByteBuffer msg) {
        this._delegate.received((Object)msg);
    }

    public void exception(Throwable t) {
        this._delegate.exception(t);
    }

    public long getConnectionId() {
        return this._delegate.getConnectionId();
    }

    public void setNetworkConnection(NetworkConnection networkConnection) {
        this.setNetworkConnection(networkConnection, (Sender<ByteBuffer>)networkConnection.getSender());
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        SocketAddress address = this._network.getLocalAddress();
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported socket address class: " + address);
        }
        this._fqdn = ((InetSocketAddress)address).getHostName();
        this._sender = sender;
    }

    public long getLastReadTime() {
        return this._delegate.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this._delegate.getLastWriteTime();
    }

    private boolean looksLikeSSL(byte[] headerBytes) {
        return this.looksLikeSSLv3ClientHello(headerBytes) || this.looksLikeSSLv2ClientHello(headerBytes);
    }

    private boolean looksLikeSSLv3ClientHello(byte[] headerBytes) {
        return headerBytes[0] == 22 && headerBytes[1] == 3 && (headerBytes[2] == 0 || headerBytes[2] == 1 || headerBytes[2] == 2 || headerBytes[2] == 3) && headerBytes[5] == 1;
    }

    private boolean looksLikeSSLv2ClientHello(byte[] headerBytes) {
        return headerBytes[0] == -128 && headerBytes[3] == 3 && (headerBytes[4] == 0 || headerBytes[4] == 1 || headerBytes[4] == 2 || headerBytes[4] == 3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SSLNetworkConnection
    implements NetworkConnection {
        private final NetworkConnection _network;
        private final SSLBufferingSender _sslSender;
        private final SSLEngine _engine;

        public SSLNetworkConnection(SSLEngine engine, NetworkConnection network, SSLBufferingSender sslSender) {
            this._engine = engine;
            this._network = network;
            this._sslSender = sslSender;
        }

        public Sender<ByteBuffer> getSender() {
            return this._sslSender;
        }

        public void start() {
            this._network.start();
        }

        public void close() {
            this._sslSender.close();
            this._network.close();
        }

        public SocketAddress getRemoteAddress() {
            return this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return this._network.getLocalAddress();
        }

        public void setMaxWriteIdle(int sec) {
            this._network.setMaxWriteIdle(sec);
        }

        public void setMaxReadIdle(int sec) {
            this._network.setMaxReadIdle(sec);
        }

        public void setPeerPrincipal(Principal principal) {
            this._network.setPeerPrincipal(principal);
        }

        public Principal getPeerPrincipal() {
            try {
                return this._engine.getSession().getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException e) {
                return null;
            }
        }

        public int getMaxReadIdle() {
            return this._network.getMaxReadIdle();
        }

        public int getMaxWriteIdle() {
            return this._network.getMaxWriteIdle();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SslDelegateProtocolEngine
    implements ServerProtocolEngine {
        private final MultiVersionProtocolEngine _decryptEngine;
        private final SSLEngine _engine;
        private final SSLReceiver _sslReceiver;
        private final SSLBufferingSender _sslSender;
        private long _lastReadTime;

        private SslDelegateProtocolEngine() {
            this._decryptEngine = new MultiVersionProtocolEngine(MultiVersionProtocolEngine.this._broker, null, false, false, MultiVersionProtocolEngine.this._supported, MultiVersionProtocolEngine.this._defaultSupportedReply, MultiVersionProtocolEngine.this._port, Transport.SSL, MultiVersionProtocolEngine.this._id, MultiVersionProtocolEngine.this._creators);
            this._engine = MultiVersionProtocolEngine.this._sslContext.createSSLEngine();
            this._engine.setUseClientMode(false);
            if (MultiVersionProtocolEngine.this._needClientAuth) {
                this._engine.setNeedClientAuth(MultiVersionProtocolEngine.this._needClientAuth);
            } else if (MultiVersionProtocolEngine.this._wantClientAuth) {
                this._engine.setWantClientAuth(MultiVersionProtocolEngine.this._wantClientAuth);
            }
            SSLStatus sslStatus = new SSLStatus();
            this._sslReceiver = new SSLReceiver(this._engine, (Receiver)this._decryptEngine, sslStatus);
            this._sslSender = new SSLBufferingSender(this._engine, MultiVersionProtocolEngine.this._sender, sslStatus);
            this._decryptEngine.setNetworkConnection(new SSLNetworkConnection(this._engine, MultiVersionProtocolEngine.this._network, this._sslSender));
        }

        public void received(ByteBuffer msg) {
            this._lastReadTime = System.currentTimeMillis();
            this._sslReceiver.received(msg);
            this._sslSender.send();
            this._sslSender.flush();
        }

        public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        }

        public SocketAddress getRemoteAddress() {
            return this._decryptEngine.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return this._decryptEngine.getLocalAddress();
        }

        public long getWrittenBytes() {
            return this._decryptEngine.getWrittenBytes();
        }

        public long getReadBytes() {
            return this._decryptEngine.getReadBytes();
        }

        public void closed() {
            this._decryptEngine.closed();
        }

        public void writerIdle() {
            this._decryptEngine.writerIdle();
        }

        public void readerIdle() {
            this._decryptEngine.readerIdle();
        }

        public void exception(Throwable t) {
            this._decryptEngine.exception(t);
        }

        public long getConnectionId() {
            return this._decryptEngine.getConnectionId();
        }

        public long getLastReadTime() {
            return this._lastReadTime;
        }

        public long getLastWriteTime() {
            return this._decryptEngine.getLastWriteTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelfDelegateProtocolEngine
    implements ServerProtocolEngine {
        private final ByteBuffer _header = ByteBuffer.allocate(8);
        private long _lastReadTime;

        private SelfDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            this._lastReadTime = System.currentTimeMillis();
            ByteBuffer msgheader = msg.duplicate();
            if (this._header.remaining() > msgheader.limit()) {
                msg.position(msg.limit());
            } else {
                msgheader.limit(this._header.remaining());
                msg.position(this._header.remaining());
            }
            this._header.put(msgheader);
            if (!this._header.hasRemaining()) {
                this._header.flip();
                byte[] headerBytes = new byte[8];
                this._header.get(headerBytes);
                SslDelegateProtocolEngine newDelegate = null;
                byte[] supportedReplyBytes = null;
                byte[] defaultSupportedReplyBytes = null;
                AmqpProtocolVersion supportedReplyVersion = null;
                for (int i = 0; newDelegate == null && i < MultiVersionProtocolEngine.this._creators.length; ++i) {
                    if (MultiVersionProtocolEngine.this._supported.contains((Object)MultiVersionProtocolEngine.this._creators[i].getVersion())) {
                        supportedReplyBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                        supportedReplyVersion = MultiVersionProtocolEngine.this._creators[i].getVersion();
                        byte[] compareBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                        boolean equal = true;
                        for (int j = 0; equal && j < compareBytes.length; ++j) {
                            equal = headerBytes[j] == compareBytes[j];
                        }
                        if (equal) {
                            newDelegate = MultiVersionProtocolEngine.this._creators[i].newProtocolEngine(MultiVersionProtocolEngine.this._broker, MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._port, MultiVersionProtocolEngine.this._transport, MultiVersionProtocolEngine.this._id);
                        }
                    }
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply == null || MultiVersionProtocolEngine.this._creators[i].getVersion() != MultiVersionProtocolEngine.this._defaultSupportedReply) continue;
                    defaultSupportedReplyBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                }
                if (newDelegate == null && MultiVersionProtocolEngine.this.looksLikeSSL(headerBytes) && MultiVersionProtocolEngine.this._sslContext != null) {
                    newDelegate = new SslDelegateProtocolEngine();
                }
                if (newDelegate == null) {
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply != null && MultiVersionProtocolEngine.this._defaultSupportedReply != supportedReplyVersion) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Default reply to unsupported protocol version was configured, changing reply from " + (Object)((Object)supportedReplyVersion) + " to " + (Object)((Object)MultiVersionProtocolEngine.this._defaultSupportedReply)));
                        }
                        supportedReplyBytes = defaultSupportedReplyBytes;
                        supportedReplyVersion = MultiVersionProtocolEngine.this._defaultSupportedReply;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Unsupported protocol version requested, replying with: " + supportedReplyVersion));
                    }
                    MultiVersionProtocolEngine.this._sender.send((Object)ByteBuffer.wrap(supportedReplyBytes));
                    MultiVersionProtocolEngine.this._sender.flush();
                    MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                    MultiVersionProtocolEngine.this._network.close();
                } else {
                    MultiVersionProtocolEngine.this._delegate = newDelegate;
                    this._header.flip();
                    MultiVersionProtocolEngine.this._delegate.received((Object)this._header);
                    if (msg.hasRemaining()) {
                        MultiVersionProtocolEngine.this._delegate.received((Object)msg);
                    }
                }
            }
        }

        public long getConnectionId() {
            return MultiVersionProtocolEngine.this._id;
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closed() {
            try {
                MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Connection from  " + this.getRemoteAddress() + " was closed before any protocol version was established."));
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    MultiVersionProtocolEngine.this._network.close();
                }
                catch (Exception e) {}
            }
        }

        public void writerIdle() {
        }

        public void readerIdle() {
            CurrentActor.get().message(ConnectionMessages.IDLE_CLOSE());
            MultiVersionProtocolEngine.this._network.close();
        }

        public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        }

        public long getLastReadTime() {
            return this._lastReadTime;
        }

        public long getLastWriteTime() {
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClosedDelegateProtocolEngine
    implements ServerProtocolEngine {
        private ClosedDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            _logger.error((Object)"Error processing incoming data, could not negotiate a common protocol");
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        public void closed() {
        }

        public void writerIdle() {
        }

        public void readerIdle() {
        }

        public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        }

        public long getLastReadTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }

        public long getConnectionId() {
            return MultiVersionProtocolEngine.this._id;
        }
    }
}

