/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private final Broker _broker;
    private final Set<AmqpProtocolVersion> _supported;
    private final AmqpProtocolVersion _defaultSupportedReply;
    private final SSLContext _sslContext;
    private final boolean _wantClientAuth;
    private final boolean _needClientAuth;
    private final Port _port;
    private final Transport _transport;
    private final ProtocolEngineCreator[] _creators;

    public MultiVersionProtocolEngineFactory(Broker broker, SSLContext sslContext, boolean wantClientAuth, boolean needClientAuth, Set<AmqpProtocolVersion> supportedVersions, AmqpProtocolVersion defaultSupportedReply, Port port, Transport transport) {
        if (defaultSupportedReply != null && !supportedVersions.contains((Object)defaultSupportedReply)) {
            throw new IllegalArgumentException("The configured default reply (" + (Object)((Object)defaultSupportedReply) + ") to an unsupported protocol version initiation is itself not supported!");
        }
        this._broker = broker;
        this._sslContext = sslContext;
        this._supported = supportedVersions;
        this._defaultSupportedReply = defaultSupportedReply;
        ArrayList<ProtocolEngineCreator> creators = new ArrayList<ProtocolEngineCreator>();
        for (ProtocolEngineCreator c : new QpidServiceLoader<ProtocolEngineCreator>().instancesOf(ProtocolEngineCreator.class)) {
            creators.add(c);
        }
        this._creators = creators.toArray(new ProtocolEngineCreator[creators.size()]);
        this._wantClientAuth = wantClientAuth;
        this._needClientAuth = needClientAuth;
        this._port = port;
        this._transport = transport;
    }

    public ServerProtocolEngine newProtocolEngine() {
        return new MultiVersionProtocolEngine(this._broker, this._sslContext, this._wantClientAuth, this._needClientAuth, this._supported, this._defaultSupportedReply, this._port, this._transport, ID_GENERATOR.getAndIncrement(), this._creators);
    }
}

