/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeReferrer;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.security.AuthorizationHolder;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AMQQueue
extends Comparable<AMQQueue>,
ExchangeReferrer,
TransactionLogResource,
BaseQueue {
    public String getName();

    public boolean getDeleteOnNoConsumers();

    public void setDeleteOnNoConsumers(boolean var1);

    public void addBinding(Binding var1);

    public void removeBinding(Binding var1);

    public List<Binding> getBindings();

    public int getBindingCount();

    public LogSubject getLogSubject();

    public long getUnackedMessageBytes();

    public long getTotalDequeueCount();

    public long getTotalEnqueueCount();

    public void setNoLocal(boolean var1);

    public boolean isAutoDelete();

    public AMQShortString getOwner();

    public AuthorizationHolder getAuthorizationHolder();

    public void setAuthorizationHolder(AuthorizationHolder var1);

    public void setExclusiveOwningSession(AMQSessionModel var1);

    public AMQSessionModel getExclusiveOwningSession();

    public VirtualHost getVirtualHost();

    public void registerSubscription(Subscription var1, boolean var2) throws AMQException;

    public void unregisterSubscription(Subscription var1) throws AMQException;

    public Collection<Subscription> getConsumers();

    public void addSubscriptionRegistrationListener(SubscriptionRegistrationListener var1);

    public void removeSubscriptionRegistrationListener(SubscriptionRegistrationListener var1);

    public int getConsumerCount();

    public int getActiveConsumerCount();

    public boolean hasExclusiveSubscriber();

    public boolean isUnused();

    public boolean isEmpty();

    public int getMessageCount();

    public int getUndeliveredMessageCount();

    public long getQueueDepth();

    public long getReceivedMessageCount();

    public long getOldestMessageArrivalTime();

    @Override
    public boolean isDeleted();

    public int delete() throws AMQException;

    public void requeue(QueueEntry var1);

    public void dequeue(QueueEntry var1, Subscription var2);

    public void decrementUnackedMsgCount(QueueEntry var1);

    public boolean resend(QueueEntry var1, Subscription var2) throws AMQException;

    public void addQueueDeleteTask(Task var1);

    public void removeQueueDeleteTask(Task var1);

    public List<QueueEntry> getMessagesOnTheQueue();

    public List<QueueEntry> getMessagesOnTheQueue(long var1, long var3);

    public List<Long> getMessagesOnTheQueue(int var1);

    public List<Long> getMessagesOnTheQueue(int var1, int var2);

    public QueueEntry getMessageOnTheQueue(long var1);

    public List<QueueEntry> getMessagesRangeOnTheQueue(long var1, long var3);

    public void visit(QueueEntryVisitor var1);

    public long getMaximumMessageSize();

    public void setMaximumMessageSize(long var1);

    public long getMaximumMessageCount();

    public void setMaximumMessageCount(long var1);

    public long getMaximumQueueDepth();

    public void setMaximumQueueDepth(long var1);

    public long getMaximumMessageAge();

    public void setMaximumMessageAge(long var1);

    public long getMinimumAlertRepeatGap();

    public void setMinimumAlertRepeatGap(long var1);

    public long getCapacity();

    public void setCapacity(long var1);

    public long getFlowResumeCapacity();

    public void setFlowResumeCapacity(long var1);

    public boolean isOverfull();

    public void deleteMessageFromTop();

    public long clearQueue() throws AMQException;

    public void checkMessageStatus() throws AMQException;

    public Set<NotificationCheck> getNotificationChecks();

    public void flushSubscription(Subscription var1) throws AMQException;

    public void deliverAsync(Subscription var1);

    public void deliverAsync();

    public void stop();

    public boolean isExclusive();

    public Exchange getAlternateExchange();

    public void setAlternateExchange(Exchange var1);

    public Map<String, Object> getArguments();

    public void checkCapacity(AMQSessionModel var1);

    public void configure(QueueConfiguration var1);

    public void setExclusive(boolean var1);

    public int getMaximumDeliveryCount();

    public void setMaximumDeliveryCount(int var1);

    public void setNotificationListener(NotificationListener var1);

    public void setDescription(String var1);

    public String getDescription();

    public long getPersistentByteDequeues();

    public long getPersistentMsgDequeues();

    public long getPersistentByteEnqueues();

    public long getPersistentMsgEnqueues();

    public long getTotalDequeueSize();

    public long getTotalEnqueueSize();

    public long getUnackedMessageCount();

    public static interface Task {
        public void doTask(AMQQueue var1) throws AMQException;
    }

    public static final class ExistingSubscriptionPreventsExclusive
    extends AMQException {
        public ExistingSubscriptionPreventsExclusive() {
            super("");
        }
    }

    public static final class ExistingExclusiveSubscription
    extends AMQException {
        public ExistingExclusiveSubscription() {
            super("");
        }
    }

    public static interface SubscriptionRegistrationListener {
        public void subscriptionRegistered(AMQQueue var1, Subscription var2);

        public void subscriptionUnregistered(AMQQueue var1, Subscription var2);
    }

    public static interface Context {
        public QueueEntry getLastSeenEntry();
    }

    public static interface NotificationListener {
        public void notifyClients(NotificationCheck var1, AMQQueue var2, String var3);
    }
}

