/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionList;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutOfOrderQueue
extends SimpleAMQQueue {
    protected OutOfOrderQueue(UUID id, String name, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, QueueEntryListFactory entryListFactory, Map<String, Object> arguments) {
        super(id, name, durable, owner, autoDelete, exclusive, virtualHost, entryListFactory, arguments);
    }

    @Override
    protected void checkSubscriptionsNotAheadOfDelivery(QueueEntry entry) {
        SubscriptionList.SubscriptionNodeIterator subIter = this.getSubscriptionList().iterator();
        while (subIter.advance() && !entry.isAcquired()) {
            QueueContext context;
            Subscription subscription = subIter.getNode().getSubscription();
            if (subscription.isClosed() || (context = (QueueContext)subscription.getQueueContext()) == null) continue;
            QueueEntry released = context.getReleasedEntry();
            while (!(entry.isAcquired() || released != null && released.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(context, released, entry))) {
                released = context.getReleasedEntry();
            }
        }
    }
}

