/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.transport.TransportException;

public class QueueRunner
implements Runnable {
    private static final Logger _logger = Logger.getLogger(QueueRunner.class);
    private final SimpleAMQQueue _queue;
    private static int IDLE = 0;
    private static int SCHEDULED = 1;
    private static int RUNNING = 2;
    private final AtomicInteger _scheduled = new AtomicInteger(IDLE);
    private final AtomicBoolean _stateChange = new AtomicBoolean();
    private final AtomicLong _lastRunAgain = new AtomicLong();
    private final AtomicLong _lastRunTime = new AtomicLong();

    public QueueRunner(SimpleAMQQueue queue) {
        this._queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this._scheduled.compareAndSet(SCHEDULED, RUNNING)) return;
        long runAgain = Long.MIN_VALUE;
        this._stateChange.set(false);
        try {
            try {
                CurrentActor.set(this._queue.getLogActor());
                runAgain = this._queue.processQueue(this);
            }
            catch (AMQException e) {
                _logger.error((Object)("Exception during asynchronous delivery by " + this.toString()), (Throwable)e);
                Object var6_3 = null;
                CurrentActor.remove();
                this._scheduled.compareAndSet(RUNNING, IDLE);
                long stateChangeCount = this._queue.getStateChangeCount();
                this._lastRunAgain.set(runAgain);
                this._lastRunTime.set(System.nanoTime());
                if (runAgain != 0L && runAgain == stateChangeCount) {
                    if (!this._stateChange.compareAndSet(true, false)) return;
                }
                if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
                this._queue.execute(this);
                return;
            }
            catch (TransportException transe) {
                String errorMessage = "Problem during asynchronous delivery by " + this.toString();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)errorMessage, (Throwable)transe);
                } else {
                    _logger.info((Object)(errorMessage + ' ' + transe.getMessage()));
                }
                Object var6_4 = null;
                CurrentActor.remove();
                this._scheduled.compareAndSet(RUNNING, IDLE);
                long stateChangeCount = this._queue.getStateChangeCount();
                this._lastRunAgain.set(runAgain);
                this._lastRunTime.set(System.nanoTime());
                if (runAgain != 0L && runAgain == stateChangeCount) {
                    if (!this._stateChange.compareAndSet(true, false)) return;
                }
                if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
                this._queue.execute(this);
                return;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            CurrentActor.remove();
            this._scheduled.compareAndSet(RUNNING, IDLE);
            long stateChangeCount = this._queue.getStateChangeCount();
            this._lastRunAgain.set(runAgain);
            this._lastRunTime.set(System.nanoTime());
            if (runAgain != 0L && runAgain == stateChangeCount) {
                if (!this._stateChange.compareAndSet(true, false)) throw throwable;
            }
            if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) throw throwable;
            this._queue.execute(this);
            throw throwable;
        }
        CurrentActor.remove();
        this._scheduled.compareAndSet(RUNNING, IDLE);
        long stateChangeCount = this._queue.getStateChangeCount();
        this._lastRunAgain.set(runAgain);
        this._lastRunTime.set(System.nanoTime());
        if (runAgain != 0L && runAgain == stateChangeCount) {
            if (!this._stateChange.compareAndSet(true, false)) return;
        }
        if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
        this._queue.execute(this);
    }

    public String toString() {
        return "QueueRunner-" + this._queue.getLogActor();
    }

    public void execute(Executor executor) {
        this._stateChange.set(true);
        if (this._scheduled.compareAndSet(IDLE, SCHEDULED)) {
            executor.execute(this);
        }
    }

    public boolean isIdle() {
        return this._scheduled.get() == IDLE;
    }
}

