/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.transport.TransportException;

class SubFlushRunner
implements Runnable {
    private static final Logger _logger = Logger.getLogger(SubFlushRunner.class);
    private final Subscription _sub;
    private static int IDLE = 0;
    private static int SCHEDULED = 1;
    private static int RUNNING = 2;
    private final AtomicInteger _scheduled = new AtomicInteger(IDLE);
    private static final long ITERATIONS = 80L;
    private final AtomicBoolean _stateChange = new AtomicBoolean();

    public SubFlushRunner(Subscription sub) {
        this._sub = sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this._scheduled.compareAndSet(SCHEDULED, RUNNING)) return;
        boolean complete = false;
        this._stateChange.set(false);
        try {
            try {
                CurrentActor.set(this._sub.getLogActor());
                complete = this.getQueue().flushSubscription(this._sub, 80L);
            }
            catch (AMQException e) {
                _logger.error((Object)("Exception during asynchronous delivery by " + this.toString()), (Throwable)e);
                Object var5_3 = null;
                CurrentActor.remove();
                this._scheduled.compareAndSet(RUNNING, IDLE);
                if (complete) {
                    if (!this._stateChange.compareAndSet(true, false)) return;
                }
                if (this._sub.isSuspended()) return;
                if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
                this.getQueue().execute(this);
                return;
            }
            catch (TransportException transe) {
                String errorMessage = "Problem during asynchronous delivery by " + this.toString();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)errorMessage, (Throwable)transe);
                } else {
                    _logger.info((Object)(errorMessage + ' ' + transe.getMessage()));
                }
                Object var5_4 = null;
                CurrentActor.remove();
                this._scheduled.compareAndSet(RUNNING, IDLE);
                if (complete) {
                    if (!this._stateChange.compareAndSet(true, false)) return;
                }
                if (this._sub.isSuspended()) return;
                if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
                this.getQueue().execute(this);
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CurrentActor.remove();
            this._scheduled.compareAndSet(RUNNING, IDLE);
            if (complete) {
                if (!this._stateChange.compareAndSet(true, false)) throw throwable;
            }
            if (this._sub.isSuspended()) throw throwable;
            if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) throw throwable;
            this.getQueue().execute(this);
            throw throwable;
        }
        CurrentActor.remove();
        this._scheduled.compareAndSet(RUNNING, IDLE);
        if (complete) {
            if (!this._stateChange.compareAndSet(true, false)) return;
        }
        if (this._sub.isSuspended()) return;
        if (!this._scheduled.compareAndSet(IDLE, SCHEDULED)) return;
        this.getQueue().execute(this);
    }

    private SimpleAMQQueue getQueue() {
        return (SimpleAMQQueue)this._sub.getQueue();
    }

    public String toString() {
        return "SubFlushRunner-" + this._sub.getLogActor();
    }

    public void execute(Executor executor) {
        this._stateChange.set(true);
        if (this._scheduled.compareAndSet(IDLE, SCHEDULED)) {
            executor.execute(this);
        }
    }
}

