/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.plugin.AccessControlFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.OperationLoggingDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManager
implements ConfigurationChangeListener {
    private static final Logger _logger = Logger.getLogger(SecurityManager.class);
    private static final ThreadLocal<Subject> _subject = new ThreadLocal();
    public static final ThreadLocal<Boolean> _accessChecksDisabled = new ClearingThreadLocal(false);
    private ConcurrentHashMap<String, AccessControl> _globalPlugins = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AccessControl> _hostPlugins = new ConcurrentHashMap();
    private boolean _managementMode;
    private Broker _broker;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, PublishAccessCheck>> _immediatePublishPropsCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, PublishAccessCheck>> _publishPropsCache = new ConcurrentHashMap();

    public SecurityManager(Broker broker, boolean managementMode) {
        this._managementMode = managementMode;
        this._broker = broker;
    }

    public SecurityManager(SecurityManager parent, String aclFile, String vhostName) {
        this._managementMode = parent._managementMode;
        if (!this._managementMode) {
            this.configureVirtualHostAclPlugin(aclFile, vhostName);
            this._globalPlugins = parent._hostPlugins;
        }
    }

    private void configureVirtualHostAclPlugin(String aclFile, String vhostName) {
        if (aclFile != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("type", "AclFile");
            attributes.put("path", aclFile);
            for (AccessControlFactory provider : new QpidServiceLoader<AccessControlFactory>().instancesOf(AccessControlFactory.class)) {
                AccessControl accessControl = provider.createInstance(attributes);
                accessControl.open();
                if (accessControl == null) continue;
                String pluginTypeName = this.getPluginTypeName(accessControl);
                this._hostPlugins.put(pluginTypeName, accessControl);
                if (!_logger.isDebugEnabled()) break;
                _logger.debug((Object)("Added access control to host plugins with name: " + vhostName));
                break;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Configured " + this._hostPlugins.size() + " access control plugins"));
        }
    }

    private String getPluginTypeName(AccessControl accessControl) {
        return accessControl.getClass().getName();
    }

    public static Subject getThreadSubject() {
        return _subject.get();
    }

    public static void setThreadSubject(Subject subject) {
        _subject.set(subject);
    }

    public static Logger getLogger() {
        return _logger;
    }

    private boolean checkAllPlugins(AccessCheck checker) {
        HashMap<String, AccessControl> remainingPlugins;
        if (_accessChecksDisabled.get().booleanValue()) {
            return true;
        }
        AbstractMap abstractMap = this._globalPlugins.isEmpty() ? Collections.emptyMap() : (remainingPlugins = this._hostPlugins.isEmpty() ? this._globalPlugins : new HashMap<String, AccessControl>(this._globalPlugins));
        if (!this._hostPlugins.isEmpty()) {
            for (Map.Entry entry : this._hostPlugins.entrySet()) {
                Result host;
                AccessControl globalPlugin = (AccessControl)remainingPlugins.get(entry.getKey());
                if (globalPlugin != null) {
                    remainingPlugins.remove(entry.getKey());
                }
                if ((host = checker.allowed((AccessControl)entry.getValue())) == Result.DENIED) {
                    return false;
                }
                if (host == Result.ALLOWED) continue;
                if (globalPlugin == null) {
                    if (host == Result.DEFER) {
                        host = ((AccessControl)entry.getValue()).getDefault();
                    }
                    if (host != Result.DENIED) continue;
                    return false;
                }
                Result global = checker.allowed(globalPlugin);
                if (global == Result.DEFER) {
                    global = globalPlugin.getDefault();
                }
                if (global == Result.ABSTAIN && host == Result.DEFER) {
                    global = ((AccessControl)entry.getValue()).getDefault();
                }
                if (global != Result.DENIED) continue;
                return false;
            }
        }
        for (AccessControl accessControl : remainingPlugins.values()) {
            Result remaining = checker.allowed(accessControl);
            if (remaining == Result.DEFER) {
                remaining = accessControl.getDefault();
            }
            if (remaining != Result.DENIED) continue;
            return false;
        }
        return true;
    }

    public boolean authoriseBind(final Exchange exch, final AMQQueue queue, final AMQShortString routingKey) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.BIND, ObjectType.EXCHANGE, new ObjectProperties(exch, queue, routingKey));
            }
        });
    }

    public boolean authoriseMethod(final Operation operation, final String componentName, final String methodName) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                ObjectProperties properties = new ObjectProperties();
                properties.setName(methodName);
                if (componentName != null) {
                    properties.put(ObjectProperties.Property.COMPONENT, componentName);
                }
                return plugin.authorise(operation, ObjectType.METHOD, properties);
            }
        });
    }

    public boolean accessManagement() {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.access(ObjectType.MANAGEMENT, null);
            }
        });
    }

    public boolean accessVirtualhost(String vhostname, final SocketAddress remoteAddress) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.access(ObjectType.VIRTUALHOST, remoteAddress);
            }
        });
    }

    public boolean authoriseConsume(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.CONSUME, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseCreateExchange(final Boolean autoDelete, final Boolean durable, final AMQShortString exchangeName, final Boolean internal, final Boolean nowait, final Boolean passive, final AMQShortString exchangeType) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.CREATE, ObjectType.EXCHANGE, new ObjectProperties(autoDelete, durable, exchangeName, internal, nowait, passive, exchangeType));
            }
        });
    }

    public boolean authoriseCreateQueue(final Boolean autoDelete, final Boolean durable, final Boolean exclusive, final Boolean nowait, final Boolean passive, final AMQShortString queueName, final String owner) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.CREATE, ObjectType.QUEUE, new ObjectProperties(autoDelete, durable, exclusive, nowait, passive, queueName, owner));
            }
        });
    }

    public boolean authoriseDelete(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.DELETE, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseUpdate(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.UPDATE, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseUpdate(final Exchange exchange) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.UPDATE, ObjectType.EXCHANGE, new ObjectProperties(exchange.getName()));
            }
        });
    }

    public boolean authoriseDelete(final Exchange exchange) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.DELETE, ObjectType.EXCHANGE, new ObjectProperties(exchange.getName()));
            }
        });
    }

    public boolean authoriseGroupOperation(final Operation operation, final String groupName) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(operation, ObjectType.GROUP, new ObjectProperties(groupName));
            }
        });
    }

    public boolean authoriseUserOperation(final Operation operation, final String userName) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(operation, ObjectType.USER, new ObjectProperties(userName));
            }
        });
    }

    public boolean authorisePublish(boolean immediate, String routingKey, String exchangeName) {
        PublishAccessCheck check;
        ConcurrentHashMap<String, ConcurrentHashMap<String, PublishAccessCheck>> cache;
        ConcurrentHashMap<String, PublishAccessCheck> exchangeMap;
        if (routingKey == null) {
            routingKey = "";
        }
        if (exchangeName == null) {
            exchangeName = "";
        }
        if ((exchangeMap = (cache = immediate ? this._immediatePublishPropsCache : this._publishPropsCache).get(exchangeName)) == null) {
            cache.putIfAbsent(exchangeName, new ConcurrentHashMap());
            exchangeMap = cache.get(exchangeName);
        }
        if ((check = exchangeMap.get(routingKey)) == null) {
            check = new PublishAccessCheck(new ObjectProperties(exchangeName, routingKey, immediate));
            exchangeMap.put(routingKey, check);
        }
        return this.checkAllPlugins(check);
    }

    public boolean authorisePurge(final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.PURGE, ObjectType.QUEUE, new ObjectProperties(queue));
            }
        });
    }

    public boolean authoriseUnbind(final Exchange exch, final AMQShortString routingKey, final AMQQueue queue) {
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.UNBIND, ObjectType.EXCHANGE, new ObjectProperties(exch, queue, routingKey));
            }
        });
    }

    public static boolean setAccessChecksDisabled(boolean status) {
        boolean current = _accessChecksDisabled.get();
        _accessChecksDisabled.set(status);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
        if (this._managementMode) {
            return;
        }
        if (object instanceof AccessControlProvider) {
            if (newState == State.ACTIVE) {
                ConcurrentHashMap<String, AccessControl> concurrentHashMap = this._hostPlugins;
                synchronized (concurrentHashMap) {
                    AccessControl accessControl = ((AccessControlProvider)object).getAccessControl();
                    String pluginTypeName = this.getPluginTypeName(accessControl);
                    this._hostPlugins.put(pluginTypeName, accessControl);
                }
            }
            if (newState == State.DELETED) {
                ConcurrentHashMap<String, AccessControl> concurrentHashMap = this._hostPlugins;
                synchronized (concurrentHashMap) {
                    AccessControl control = ((AccessControlProvider)object).getAccessControl();
                    String pluginTypeName = this.getPluginTypeName(control);
                    if (this._hostPlugins.containsValue(control)) {
                        AccessControl other = null;
                        Collection<AccessControlProvider> providers = this._broker.getAccessControlProviders();
                        for (AccessControlProvider p : providers) {
                            AccessControl ac;
                            if (p == object || p.getActualState() != State.ACTIVE || !pluginTypeName.equals(this.getPluginTypeName(ac = p.getAccessControl()))) continue;
                            other = ac;
                            break;
                        }
                        if (other != null) {
                            this._hostPlugins.replace(pluginTypeName, control, other);
                        } else {
                            this._hostPlugins.remove(pluginTypeName);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void childAdded(ConfiguredObject object, ConfiguredObject child) {
    }

    @Override
    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
    }

    @Override
    public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
    }

    public boolean authoriseConfiguringBroker(String configuredObjectName, Class<? extends ConfiguredObject> configuredObjectType, Operation configuredObjectOperation) {
        String description = String.format("%s %s '%s'", configuredObjectOperation == null ? null : configuredObjectOperation.name().toLowerCase(), configuredObjectType == null ? null : configuredObjectType.getSimpleName().toLowerCase(), configuredObjectName);
        final OperationLoggingDetails properties = new OperationLoggingDetails(description);
        return this.checkAllPlugins(new AccessCheck(){

            Result allowed(AccessControl plugin) {
                return plugin.authorise(Operation.CONFIGURE, ObjectType.BROKER, properties);
            }
        });
    }

    private class PublishAccessCheck
    extends AccessCheck {
        private final ObjectProperties _props;

        public PublishAccessCheck(ObjectProperties props) {
            this._props = props;
        }

        Result allowed(AccessControl plugin) {
            return plugin.authorise(Operation.PUBLISH, ObjectType.EXCHANGE, this._props);
        }
    }

    private abstract class AccessCheck {
        private AccessCheck() {
        }

        abstract Result allowed(AccessControl var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClearingThreadLocal
    extends ThreadLocal<Boolean> {
        private Boolean _defaultValue;

        public ClearingThreadLocal(Boolean defaultValue) {
            this._defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this._defaultValue;
        }

        @Override
        public void set(Boolean value) {
            if (value == this._defaultValue) {
                super.remove();
            } else {
                super.set(value);
            }
        }

        @Override
        public Boolean get() {
            Boolean value = (Boolean)super.get();
            if (value == this._defaultValue) {
                super.remove();
            }
            return value;
        }
    }
}

