/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectCreator {
    private AuthenticationManager _authenticationManager;
    private Collection<GroupProvider> _groupProviders;

    public SubjectCreator(AuthenticationManager authenticationManager, Collection<GroupProvider> groupProviders) {
        this._authenticationManager = authenticationManager;
        this._groupProviders = groupProviders;
    }

    public String getMechanisms() {
        return this._authenticationManager.getMechanisms();
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        return this._authenticationManager.createSaslServer(mechanism, localFQDN, externalPrincipal);
    }

    public SubjectAuthenticationResult authenticate(SaslServer server, byte[] response) {
        AuthenticationResult authenticationResult = this._authenticationManager.authenticate(server, response);
        if (server.isComplete()) {
            String username = server.getAuthorizationID();
            return this.createResultWithGroups(username, authenticationResult);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public SubjectAuthenticationResult authenticate(String username, String password) {
        AuthenticationResult authenticationResult = this._authenticationManager.authenticate(username, password);
        return this.createResultWithGroups(username, authenticationResult);
    }

    private SubjectAuthenticationResult createResultWithGroups(String username, AuthenticationResult authenticationResult) {
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject authenticationSubject = new Subject();
            authenticationSubject.getPrincipals().addAll(authenticationResult.getPrincipals());
            authenticationSubject.getPrincipals().addAll(this.getGroupPrincipals(username));
            authenticationSubject.setReadOnly();
            return new SubjectAuthenticationResult(authenticationResult, authenticationSubject);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public Subject createSubjectWithGroups(String username) {
        Subject authenticationSubject = new Subject();
        authenticationSubject.getPrincipals().add(new AuthenticatedPrincipal(username));
        authenticationSubject.getPrincipals().addAll(this.getGroupPrincipals(username));
        authenticationSubject.setReadOnly();
        return authenticationSubject;
    }

    public Set<Principal> getGroupPrincipals(String username) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (GroupProvider groupProvider : this._groupProviders) {
            Set<Principal> groups = groupProvider.getGroupPrincipalsForUser(username);
            if (groups == null) continue;
            principals.addAll(groups);
        }
        return Collections.unmodifiableSet(principals);
    }

    public boolean isAnonymousAuthenticationAllowed() {
        return this._authenticationManager instanceof AnonymousAuthenticationManager;
    }
}

