/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.HashedUser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HashedInitialiser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HashedSaslServer;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HexInitialiser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HexSaslServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64MD5PasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<HashedUser> {
    private final Logger _logger = Logger.getLogger(Base64MD5PasswordFilePrincipalDatabase.class);
    private String _mechanismsString;
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();

    public Base64MD5PasswordFilePrincipalDatabase() {
        CRAMMD5HashedInitialiser crammd5HashedInitialiser = new CRAMMD5HashedInitialiser();
        crammd5HashedInitialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5-HASHED", crammd5HashedInitialiser.getCallbackHandler());
        CRAMMD5HexInitialiser crammd5HexInitialiser = new CRAMMD5HexInitialiser();
        crammd5HexInitialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5-HEX", crammd5HexInitialiser.getCallbackHandler());
        this._mechanismsString = "CRAM-MD5-HASHED CRAM-MD5-HEX";
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        byte[] MD5byteArray;
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specfied users password");
        }
        byte[] byteArray = new byte[password.length];
        int index = 0;
        for (char c : password) {
            byteArray[index++] = (byte)c;
        }
        try {
            MD5byteArray = HashedUser.getMD5(byteArray);
        }
        catch (Exception e1) {
            this.getLogger().warn((Object)("Unable to hash password for user '" + principal + "' for comparison"));
            return false;
        }
        char[] hashedPassword = new char[MD5byteArray.length];
        index = 0;
        for (byte c : MD5byteArray) {
            hashedPassword[index++] = (char)c;
        }
        return this.compareCharArray(pwd, hashedPassword);
    }

    @Override
    protected HashedUser createUserFromPassword(Principal principal, char[] passwd) {
        return new HashedUser(principal.getName(), passwd);
    }

    @Override
    protected HashedUser createUserFromFileData(String[] result) {
        return new HashedUser(result);
    }

    @Override
    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public String getMechanisms() {
        return this._mechanismsString;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        CallbackHandler callbackHandler = this._callbackHandlerMap.get(mechanism);
        if (callbackHandler == null) {
            throw new SaslException("Unsupported mechanism: " + mechanism);
        }
        if ("CRAM-MD5-HASHED".equals(mechanism)) {
            return new CRAMMD5HashedSaslServer(mechanism, "AMQP", localFQDN, null, callbackHandler);
        }
        if ("CRAM-MD5-HEX".equals(mechanism)) {
            return new CRAMMD5HexSaslServer(mechanism, "AMQP", localFQDN, null, callbackHandler);
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }
}

