/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.external.ExternalSaslServer;

public class ExternalAuthenticationManager
implements AuthenticationManager {
    private static final String EXTERNAL = "EXTERNAL";
    private boolean _useFullDN = false;

    ExternalAuthenticationManager(boolean useFullDN) {
        this._useFullDN = useFullDN;
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return EXTERNAL;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (EXTERNAL.equals(mechanism)) {
            return new ExternalSaslServer(externalPrincipal, this._useFullDN);
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            server.evaluateResponse(response != null ? response : new byte[]{});
            Principal principal = ((ExternalSaslServer)server).getAuthenticatedPrincipal();
            if (principal != null) {
                return new AuthenticationResult(principal);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return new AuthenticationResult(new UsernamePrincipal(username));
    }

    public void close() {
    }

    public void onCreate() {
    }

    public void onDelete() {
    }
}

