/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationManager;
import org.apache.qpid.server.util.ResourceBundleLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLDAPAuthenticationManagerFactory
implements AuthenticationManagerFactory {
    public static final String RESOURCE_BUNDLE = "org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationProviderAttributeDescriptions";
    private static final String DEFAULT_LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String PROVIDER_TYPE = "SimpleLDAP";
    public static final String ATTRIBUTE_LDAP_CONTEXT_FACTORY = "ldapContextFactory";
    public static final String ATTRIBUTE_SEARCH_FILTER = "searchFilter";
    public static final String ATTRIBUTE_SEARCH_CONTEXT = "searchContext";
    public static final String ATTRIBUTE_PROVIDER_AUTH_URL = "providerAuthUrl";
    public static final String ATTRIBUTE_PROVIDER_URL = "providerUrl";
    public static final Collection<String> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("type", "providerUrl", "searchContext", "searchFilter", "providerAuthUrl", "ldapContextFactory"));

    @Override
    public AuthenticationManager createInstance(Map<String, Object> attributes) {
        if (attributes == null || !PROVIDER_TYPE.equals(attributes.get("type"))) {
            return null;
        }
        String providerUrl = (String)attributes.get(ATTRIBUTE_PROVIDER_URL);
        String providerAuthUrl = (String)attributes.get(ATTRIBUTE_PROVIDER_AUTH_URL);
        if (providerAuthUrl == null) {
            providerAuthUrl = providerUrl;
        }
        String searchContext = (String)attributes.get(ATTRIBUTE_SEARCH_CONTEXT);
        String searchFilter = (String)attributes.get(ATTRIBUTE_SEARCH_FILTER);
        String ldapContextFactory = (String)attributes.get(ATTRIBUTE_LDAP_CONTEXT_FACTORY);
        if (ldapContextFactory == null) {
            ldapContextFactory = DEFAULT_LDAP_CONTEXT_FACTORY;
        }
        return new SimpleLDAPAuthenticationManager(providerUrl, providerAuthUrl, searchContext, searchFilter, ldapContextFactory);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTES;
    }

    @Override
    public String getType() {
        return PROVIDER_TYPE;
    }

    @Override
    public Map<String, String> getAttributeDescriptions() {
        return ResourceBundleLoader.getResources(RESOURCE_BUNDLE);
    }
}

