/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.external;

import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.UsernamePrincipal;

public class ExternalSaslServer
implements SaslServer {
    private static final Logger LOGGER = Logger.getLogger(ExternalSaslServer.class);
    public static final String MECHANISM = "EXTERNAL";
    private boolean _complete = false;
    private final Principal _externalPrincipal;
    private boolean _useFullDN = false;

    public ExternalSaslServer(Principal externalPrincipal, boolean useFullDN) {
        this._useFullDN = useFullDN;
        this._externalPrincipal = externalPrincipal;
    }

    public String getMechanismName() {
        return MECHANISM;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        this._complete = true;
        return null;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public String getAuthorizationID() {
        return this.getAuthenticatedPrincipal().getName();
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    public void dispose() throws SaslException {
    }

    public Principal getAuthenticatedPrincipal() {
        if (this._externalPrincipal instanceof X500Principal && !this._useFullDN) {
            String dn = ((X500Principal)this._externalPrincipal).getName("RFC2253");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Parsing username from Principal DN: " + dn));
            }
            if (dn.contains("CN=")) {
                String username = dn.substring(dn.indexOf("CN=") + 3, dn.indexOf(",", dn.indexOf("CN=")) != -1 ? dn.indexOf(",", dn.indexOf("CN=")) : dn.length());
                if (username.isEmpty()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"CN value was empty in Principal name, unable to construct username");
                    }
                    return null;
                }
                if (dn.contains("DC=")) {
                    int start = 0;
                    String dc = "";
                    while (dn.indexOf("DC=", start) != -1) {
                        int dcStart = dn.indexOf("DC=", start) + 3;
                        int dcEnd = dn.indexOf(",", dn.indexOf("DC=", start)) != -1 ? dn.indexOf(",", dn.indexOf("DC=", start)) : dn.length();
                        dc = dc.isEmpty() ? dn.substring(dcStart, dcEnd) : dc.concat(".").concat(dn.substring(dcStart, dcEnd));
                        start = dn.indexOf("DC=", start) + 1;
                    }
                    username = username.concat("@").concat(dc);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Constructing Principal with username: " + username));
                }
                return new UsernamePrincipal(username);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"No CN= present in DN, unable to construct username");
            }
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Using external Principal: " + this._externalPrincipal));
        }
        return this._externalPrincipal;
    }
}

