/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.group.GroupDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroupDatabase
implements GroupDatabase {
    private static final Logger LOGGER = Logger.getLogger(FileGroupDatabase.class);
    private Map<String, Set<String>> _groupToUserMap = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<String>> _userToGroupMap = new ConcurrentHashMap<String, Set<String>>();
    private String _groupFile;

    @Override
    public Set<String> getAllGroups() {
        return Collections.unmodifiableSet(this._groupToUserMap.keySet());
    }

    public synchronized void setGroupFile(String groupFile) throws IOException {
        File file = new File(groupFile);
        if (!file.canRead()) {
            throw new FileNotFoundException(groupFile + " cannot be found or is not readable");
        }
        this.readGroupFile(groupFile);
    }

    @Override
    public Set<String> getUsersInGroup(String group) {
        if (group == null) {
            LOGGER.warn((Object)"Requested user set for null group. Returning empty set.");
            return Collections.emptySet();
        }
        Set<String> set = this._groupToUserMap.get(group);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public synchronized void addUserToGroup(String user, String group) {
        Set<String> users = this._groupToUserMap.get(group);
        if (users == null) {
            throw new IllegalArgumentException("Group " + group + " does not exist so could not add " + user + " to it");
        }
        users.add(user);
        Set<String> groups = this._userToGroupMap.get(user);
        if (groups == null) {
            groups = new ConcurrentSkipListSet<String>();
            this._userToGroupMap.put(user, groups);
        }
        groups.add(group);
        this.update();
    }

    @Override
    public synchronized void removeUserFromGroup(String user, String group) {
        Set<String> users = this._groupToUserMap.get(group);
        if (users == null) {
            throw new IllegalArgumentException("Group " + group + " does not exist so could not remove " + user + " from it");
        }
        users.remove(user);
        Set<String> groups = this._userToGroupMap.get(user);
        if (groups != null) {
            groups.remove(group);
        }
        this.update();
    }

    @Override
    public Set<String> getGroupsForUser(String user) {
        if (user == null) {
            LOGGER.warn((Object)"Requested group set for null user. Returning empty set.");
            return Collections.emptySet();
        }
        Set<String> groups = this._userToGroupMap.get(user);
        if (groups == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(groups);
    }

    @Override
    public synchronized void createGroup(String group) {
        ConcurrentSkipListSet users = new ConcurrentSkipListSet();
        this._groupToUserMap.put(group, users);
        this.update();
    }

    @Override
    public synchronized void removeGroup(String group) {
        this._groupToUserMap.remove(group);
        for (Set<String> groupsForUser : this._userToGroupMap.values()) {
            groupsForUser.remove(group);
        }
        this.update();
    }

    private synchronized void update() {
        if (this._groupFile != null) {
            try {
                this.writeGroupFile(this._groupFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to persist change to file " + this._groupFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void readGroupFile(String groupFile) throws IOException {
        Properties propertiesFile;
        block7: {
            this._groupFile = groupFile;
            this._groupToUserMap.clear();
            this._userToGroupMap.clear();
            propertiesFile = new Properties();
            FileInputStream fileInputStream = new FileInputStream(groupFile);
            try {
                propertiesFile.load(fileInputStream);
                Object var5_4 = null;
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
        }
        Iterator<String> i$ = propertiesFile.stringPropertyNames().iterator();
        block2: while (i$.hasNext()) {
            String propertyName = i$.next();
            this.validatePropertyNameIsGroupName(propertyName);
            String groupName = propertyName.replaceAll("\\.users$", "");
            String userString = propertiesFile.getProperty(propertyName);
            ConcurrentSkipListSet<String> userSet = this.buildUserSetFromCommaSeparateValue(userString);
            this._groupToUserMap.put(groupName, userSet);
            Iterator i$2 = userSet.iterator();
            while (true) {
                if (!i$2.hasNext()) continue block2;
                String userName = (String)i$2.next();
                Set<String> groupsForThisUser = this._userToGroupMap.get(userName);
                if (groupsForThisUser == null) {
                    groupsForThisUser = new ConcurrentSkipListSet<String>();
                    this._userToGroupMap.put(userName, groupsForThisUser);
                }
                groupsForThisUser.add(groupName);
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void writeGroupFile(String groupFile) throws IOException {
        Properties propertiesFile = new Properties();
        for (String group : this._groupToUserMap.keySet()) {
            Set<String> users = this._groupToUserMap.get(group);
            String userList = StringUtils.join(users, (String)",");
            propertiesFile.setProperty(group + ".users", userList);
        }
        String comment = "Written " + new Date();
        FileOutputStream fileOutputStream = new FileOutputStream(groupFile);
        try {
            propertiesFile.store(fileOutputStream, comment);
            Object var8_7 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    private void validatePropertyNameIsGroupName(String propertyName) {
        if (!propertyName.endsWith(".users")) {
            throw new IllegalArgumentException("Invalid definition with name '" + propertyName + "'. Group definitions must end with suffix '.users'");
        }
    }

    private ConcurrentSkipListSet<String> buildUserSetFromCommaSeparateValue(String userString) {
        String[] users = userString.split(",");
        ConcurrentSkipListSet<String> userSet = new ConcurrentSkipListSet<String>();
        for (String user : users) {
            String trimmed = user.trim();
            if (trimmed.isEmpty()) continue;
            userSet.add(trimmed);
        }
        return userSet;
    }
}

